/*
 * Decompiled with CFR 0.152.
 */
package dorkbox.util.swing;

import dorkbox.util.ActionHandlerLong;
import dorkbox.util.Property;
import dorkbox.util.swing.SwingActiveRender;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Toolkit;
import java.util.List;

public class ActiveRenderLoop
implements Runnable {
    @Property
    public static int TARGET_FPS = 30;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        long lastTime = System.nanoTime();
        long OPTIMAL_TIME = 1000000000 / TARGET_FPS;
        Graphics graphics = null;
        while (SwingActiveRender.hasActiveRenders) {
            long now = System.nanoTime();
            long updateDeltaNanos = now - lastTime;
            lastTime = now;
            for (int i = 0; i < SwingActiveRender.activeRenderEvents.size(); ++i) {
                ActionHandlerLong actionHandlerLong = SwingActiveRender.activeRenderEvents.get(i);
                actionHandlerLong.handle(updateDeltaNanos);
            }
            List<Component> i = SwingActiveRender.activeRenders;
            synchronized (i) {
                List<Component> activeRenders = SwingActiveRender.activeRenders;
                for (Component component : activeRenders) {
                    if (!component.isDisplayable()) continue;
                    try {
                        graphics = component.getGraphics();
                        component.paint(graphics);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    finally {
                        if (graphics == null) continue;
                        graphics.dispose();
                    }
                }
            }
            Toolkit.getDefaultToolkit().sync();
            try {
                int l = (int)(lastTime - System.nanoTime() + OPTIMAL_TIME);
                int millis = l / 1000000;
                if (millis > 1) {
                    Thread.sleep(millis);
                    continue;
                }
                Thread.yield();
            }
            catch (InterruptedException interruptedException) {}
        }
    }
}

