/*
 * Decompiled with CFR 0.152.
 */
package dorkbox.util.jna.linux;

import com.sun.jna.Pointer;
import com.sun.jna.ptr.PointerByReference;
import dorkbox.executor.ShellExecutor;
import dorkbox.util.FileUtil;
import dorkbox.util.MathUtil;
import dorkbox.util.OS;
import dorkbox.util.OSUtil;
import dorkbox.util.Swt;
import dorkbox.util.jna.linux.GObject;
import dorkbox.util.jna.linux.Gtk;
import dorkbox.util.jna.linux.GtkEventDispatch;
import dorkbox.util.jna.linux.structs.GtkRequisition;
import dorkbox.util.jna.linux.structs.GtkStyle;
import dorkbox.util.jna.linux.structs.PangoRectangle;
import java.awt.Color;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.io.File;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import org.slf4j.LoggerFactory;

public class GtkTheme {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Rectangle getPixelTextHeight(String text) {
        Pointer menu = null;
        Pointer item = null;
        try {
            menu = Gtk.Gtk2.gtk_menu_new();
            item = Gtk.Gtk2.gtk_image_menu_item_new_with_mnemonic(text);
            Gtk.Gtk2.gtk_container_add(menu, item);
            Gtk.Gtk2.gtk_widget_realize(menu);
            Gtk.Gtk2.gtk_widget_realize(item);
            Gtk.Gtk2.gtk_widget_show_all(menu);
            Pointer textLabel = Gtk.Gtk2.gtk_bin_get_child(item);
            Pointer pangoLayout = Gtk.Gtk2.gtk_label_get_layout(textLabel);
            PangoRectangle ink = new PangoRectangle();
            Gtk.Gtk2.pango_layout_get_pixel_extents(pangoLayout, ink.getPointer(), null);
            ink.read();
            Rectangle rectangle = new Rectangle(ink.width, ink.height);
            Gtk.Gtk2.gtk_widget_destroy(item);
            Gtk.Gtk2.gtk_widget_destroy(menu);
            return rectangle;
        }
        catch (Throwable throwable) {
            Gtk.Gtk2.gtk_widget_destroy(item);
            Gtk.Gtk2.gtk_widget_destroy(menu);
            throw throwable;
        }
    }

    public static int getMenuEntryImageSize() {
        final AtomicReference imageHeight = new AtomicReference();
        GtkEventDispatch.dispatchAndWait(new Runnable(){

            @Override
            public void run() {
                Pointer offscreen = Gtk.Gtk2.gtk_offscreen_window_new();
                Pointer item = Gtk.Gtk2.gtk_image_menu_item_new_from_stock("gtk-paste", null);
                Gtk.Gtk2.gtk_container_add(offscreen, item);
                PointerByReference r = new PointerByReference();
                GObject.g_object_get(item, "image", r.getPointer(), null);
                Pointer imageWidget = r.getValue();
                GtkRequisition gtkRequisition = new GtkRequisition();
                Gtk.Gtk2.gtk_widget_size_request(imageWidget, gtkRequisition.getPointer());
                gtkRequisition.read();
                imageHeight.set(gtkRequisition.height);
            }
        });
        int height = (Integer)imageHeight.get();
        if (height > 0) {
            return height;
        }
        LoggerFactory.getLogger(GtkTheme.class).warn("Unable to get tray menu image size. Using default.");
        return 16;
    }

    public static int getIndicatorSize() {
        List<String> lines;
        OSUtil.DesktopEnv.Env env;
        AtomicInteger screenDPI;
        block41: {
            String envVar;
            int dpi2;
            Object detectedValue;
            double defaultDPI = 96.0;
            final AtomicReference<Double> screenScale = new AtomicReference<Double>();
            screenDPI = new AtomicInteger();
            screenScale.set(0.0);
            screenDPI.set(0);
            GtkEventDispatch.dispatchAndWait(new Runnable(){

                @Override
                public void run() {
                    Pointer window;
                    Pointer screen = Gtk.Gtk2.gdk_screen_get_default();
                    if (screen != null) {
                        screenDPI.set((int)Gtk.Gtk2.gdk_screen_get_resolution(screen));
                    }
                    if (Gtk.isGtk3 && (window = Gtk.Gtk2.gdk_get_default_root_window()) != null) {
                        double scale = Gtk.Gtk3.gdk_window_get_scale_factor(window);
                        screenScale.set(scale);
                    }
                }
            });
            if (screenDPI.get() <= 0 && (detectedValue = Toolkit.getDefaultToolkit().getDesktopProperty("gnome.Xft/DPI")) instanceof Integer && (dpi2 = (Integer)detectedValue / 1024) == -1) {
                screenDPI.set(96);
            }
            if (screenDPI.get() < 50) {
                screenDPI.set(96);
            }
            if ((Double)screenScale.get() == 0.0 && (envVar = System.getenv("QT_AUTO_SCREEN_SCALE_FACTOR")) != null) {
                try {
                    screenScale.set(Double.parseDouble(envVar));
                }
                catch (Exception dpi2) {
                    // empty catch block
                }
            }
            if ((Double)screenScale.get() == 0.0 && (envVar = System.getenv("QT_SCALE_FACTOR")) != null) {
                try {
                    screenScale.set(Double.parseDouble(envVar));
                }
                catch (Exception dpi2) {
                    // empty catch block
                }
            }
            if ((Double)screenScale.get() == 0.0 && (envVar = System.getenv("GDK_SCALE")) != null) {
                try {
                    screenScale.set(Double.parseDouble(envVar));
                }
                catch (Exception dpi2) {
                    // empty catch block
                }
            }
            if ((Double)screenScale.get() == 0.0 && (envVar = System.getenv("ELM_SCALE")) != null) {
                try {
                    screenScale.set(Double.parseDouble(envVar));
                }
                catch (Exception dpi2) {
                    // empty catch block
                }
            }
            env = OSUtil.DesktopEnv.get();
            try {
                Object value;
                double scalingFactor;
                ShellExecutor shellVersion = new ShellExecutor();
                shellVersion.setExecutable("gsettings");
                shellVersion.addArgument("get");
                shellVersion.addArgument("org.gnome.desktop.interface");
                shellVersion.addArgument("scaling-factor");
                shellVersion.start();
                String output = shellVersion.getOutput();
                if (!output.isEmpty() && output.contains("uint32") && (scalingFactor = Double.parseDouble((String)(value = output.substring(output.indexOf("uint") + 7, output.length())))) >= 1.0) {
                    screenScale.set(scalingFactor);
                }
            }
            catch (Throwable shellVersion) {
                // empty catch block
            }
            if (OSUtil.DesktopEnv.isKDE()) {
                try {
                    File customSettings = new File("/usr/bin/startkde-custom");
                    if (!customSettings.canRead()) break block41;
                    lines = FileUtil.readLines(customSettings);
                    for (String line : lines) {
                        String scale;
                        double scalingFactor;
                        Object str;
                        int i = line.indexOf((String)(str = "export GDK_SCALE="));
                        if (i <= -1 || !((scalingFactor = Double.parseDouble(scale = line.substring(i + ((String)str).length()))) >= 1.0)) continue;
                        screenScale.set(scalingFactor);
                        break;
                    }
                }
                catch (Exception customSettings) {
                    // empty catch block
                }
            }
        }
        if (OSUtil.DesktopEnv.isKDE()) {
            File mainFile = new File("/usr/share/plasma/plasmoids/org.kde.plasma.private.systemtray/contents/config/main.xml");
            if (mainFile.canRead()) {
                lines = FileUtil.readLines(mainFile);
                boolean found = false;
                for (String line : lines) {
                    String substring;
                    int index;
                    if (line.contains("<entry name=\"iconSize\" type=\"Int\">")) {
                        found = true;
                    }
                    String str = "<default>";
                    if (!found || (index = line.indexOf(str)) <= -1 || !MathUtil.isInteger(substring = line.substring(index + str.length(), line.indexOf("</default>", index)))) continue;
                    int imageSize = 0;
                    int imageSizeEnum = Integer.parseInt(substring);
                    switch (imageSizeEnum) {
                        case 0: {
                            imageSize = 16;
                            break;
                        }
                        case 1: {
                            imageSize = 22;
                            break;
                        }
                        case 2: {
                            imageSize = 32;
                            break;
                        }
                        case 3: {
                            imageSize = 48;
                            break;
                        }
                        case 4: {
                            imageSize = 64;
                            break;
                        }
                        case 5: {
                            imageSize = 128;
                        }
                    }
                    if (imageSize <= 0) continue;
                    double scaleRatio = (double)screenDPI.get() / 96.0;
                    return (int)(scaleRatio * (double)imageSize);
                }
            }
        } else {
            if (OSUtil.Linux.isUbuntu() && OSUtil.DesktopEnv.isUnity(env)) {
                return 22;
            }
            if (env == OSUtil.DesktopEnv.Env.XFCE) {
                String properties = OSUtil.DesktopEnv.queryXfce("xfce4-panel", null);
                List<String> propertiesAsList = Arrays.asList(properties.split(OS.LINE_SEPARATOR));
                for (String prop : propertiesAsList) {
                    if (!prop.startsWith("/plugins/") || !prop.endsWith("/size-max")) continue;
                    String size = OSUtil.DesktopEnv.queryXfce("xfce4-panel", prop);
                    try {
                        return Integer.parseInt(size);
                    }
                    catch (Exception e) {
                        LoggerFactory.getLogger(GtkTheme.class).error("Unable to get XFCE notification panel size for channel '{}', property '{}'", new Object[]{"xfce4-panel", prop, e});
                    }
                }
                return 22;
            }
            final AtomicInteger traySize = new AtomicInteger();
            if (!Swt.isLoaded) {
                GtkEventDispatch.dispatchAndWait(new Runnable(){

                    @Override
                    public void run() {
                        Pointer screen = Gtk.Gtk2.gdk_screen_get_default();
                        Pointer settings = null;
                        if (screen != null) {
                            settings = Gtk.Gtk2.gtk_settings_get_for_screen(screen);
                        }
                        if (settings != null) {
                            PointerByReference pointer = new PointerByReference();
                            GObject.g_object_get(settings, "gtk-icon-sizes", pointer.getPointer(), null);
                            Pointer value = pointer.getValue();
                            if (value != null) {
                                String[] strings;
                                String iconSizes = value.getString(0L);
                                for (String var : strings = new String[]{"panel-menu-bar=", "panel=", "gtk-large-toolbar=", "gtk-small-toolbar="}) {
                                    String size;
                                    int i = iconSizes.indexOf(var);
                                    if (i < 0 || !MathUtil.isInteger(size = iconSizes.substring(i + var.length(), iconSizes.indexOf(",", i)))) continue;
                                    traySize.set(Integer.parseInt(size));
                                    return;
                                }
                            }
                        }
                    }
                });
            }
            int i = traySize.get();
            if (i != 0) {
                return i;
            }
        }
        LoggerFactory.getLogger(GtkTheme.class).warn("Unable to get tray image size. Using default.");
        return 24;
    }

    public static Color getTextColor() {
        final AtomicReference<Object> color = new AtomicReference<Object>(null);
        GtkEventDispatch.dispatchAndWait(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Color c = null;
                Pointer menu = null;
                Pointer item = null;
                try {
                    menu = Gtk.Gtk2.gtk_menu_new();
                    item = Gtk.Gtk2.gtk_image_menu_item_new_with_mnemonic("a");
                    Gtk.Gtk2.gtk_container_add(menu, item);
                    Gtk.Gtk2.gtk_widget_realize(menu);
                    Gtk.Gtk2.gtk_widget_realize(item);
                    Gtk.Gtk2.gtk_widget_show_all(menu);
                    GtkStyle style = Gtk.Gtk2.gtk_rc_get_style(item);
                    style.read();
                    c = style.fg[0].getColor();
                    color.set(c);
                    Gtk.Gtk2.gtk_widget_destroy(item);
                    Gtk.Gtk2.gtk_widget_destroy(menu);
                }
                catch (Throwable throwable) {
                    Gtk.Gtk2.gtk_widget_destroy(item);
                    Gtk.Gtk2.gtk_widget_destroy(menu);
                    throw throwable;
                }
            }
        });
        return color.get();
    }
}

