/*
 * Decompiled with CFR 0.152.
 */
package dorkbox.systemTray.util;

import dorkbox.systemTray.SystemTray;
import dorkbox.util.ClassLoaderUtil;
import dorkbox.util.OS;
import java.awt.AWTException;
import java.awt.Robot;
import java.lang.reflect.Method;
import java.util.Locale;
import javassist.ClassPool;
import javassist.CtBehavior;
import javassist.CtClass;
import javassist.CtConstructor;
import javassist.CtField;
import javassist.CtMethod;
import javassist.CtNewMethod;
import javassist.bytecode.BadBytecode;
import javassist.bytecode.CodeIterator;
import javassist.bytecode.ConstPool;
import javassist.bytecode.InstructionPrinter;
import javassist.bytecode.MethodInfo;
import javassist.bytecode.Mnemonic;

public class SystemTrayFixes {
    private static boolean isSwingTrayLoaded() {
        String className = OS.isWindows() ? "sun.awt.windows.WTrayIconPeer" : (OS.isMacOsX() ? "sun.lwawt.macosx.CTrayIcon" : "sun.awt.X11.XTrayIconPeer");
        try {
            Method m = ClassLoader.class.getDeclaredMethod("findLoadedClass", String.class);
            m.setAccessible(true);
            ClassLoader cl = ClassLoader.getSystemClassLoader();
            return null != m.invoke((Object)cl, className) || null != m.invoke((Object)cl, "java.awt.SystemTray");
        }
        catch (Throwable e) {
            if (SystemTray.DEBUG) {
                SystemTray.logger.debug("Error detecting if the Swing SystemTray is loaded, unexpected error.", e);
            }
            return true;
        }
    }

    private static boolean isOracleVM() {
        String vendor = System.getProperty("java.vendor").toLowerCase(Locale.US);
        return vendor.contains("sun ") || vendor.contains("oracle ");
    }

    public static void fixWindows(int trayIconSize) {
        if (SystemTrayFixes.isOracleVM()) {
            return;
        }
        if (SystemTrayFixes.isSwingTrayLoaded()) {
            throw new RuntimeException("Unable to initialize the Swing System Tray, it has already been created!");
        }
        try {
            Robot robot = new Robot();
            ClassPool pool = ClassPool.getDefault();
            CtClass trayClass = pool.get("sun.awt.windows.WSystemTrayPeer");
            trayClass.setModifiers(trayClass.getModifiers() & 1);
            trayClass.getConstructors()[0].setModifiers(trayClass.getConstructors()[0].getModifiers() & 1);
            CtMethod method = trayClass.getDeclaredMethod("getTrayIconSize");
            CtBehavior[] methodInfos = new CtBehavior[]{method};
            SystemTrayFixes.fixTraySize(methodInfos, 16, trayIconSize);
            method.getMethodInfo().rebuildStackMapForME(trayClass.getClassPool());
            byte[] trayBytes = trayClass.toBytecode();
            CtClass trayIconClass = pool.get("sun.awt.windows.WTrayIconPeer");
            CtMethod ctMethodCreate = trayIconClass.getDeclaredMethod("createNativeImage");
            CtMethod ctMethodUpdate = trayIconClass.getDeclaredMethod("updateNativeImage");
            int TRAY_MASK = trayIconSize * trayIconSize / 8;
            ctMethodCreate.setBody("{java.awt.image.BufferedImage bufferedImage = $1;java.awt.image.Raster rasterImage = bufferedImage.getRaster();final byte[] mask = new byte[" + TRAY_MASK + "];final int pixels[] = ((java.awt.image.DataBufferInt)rasterImage.getDataBuffer()).getData();int numberOfPixels = pixels.length;int rasterImageWidth = rasterImage.getWidth();for (int i = 0; i < numberOfPixels; i++) {int iByte = i / 8;int augmentMask = 1 << (7 - (i % 8));if ((pixels[i] & 0xFF000000) == 0) {if (iByte < mask.length) {mask[iByte] |= augmentMask;}}}if (rasterImage instanceof sun.awt.image.IntegerComponentRaster) {rasterImageWidth = ((sun.awt.image.IntegerComponentRaster)rasterImage).getScanlineStride();}setNativeIcon(((java.awt.image.DataBufferInt)bufferedImage.getRaster().getDataBuffer()).getData(), mask, rasterImageWidth, rasterImage.getWidth(), rasterImage.getHeight());}");
            ctMethodUpdate.setBody("{java.awt.Image image = $1;if (isDisposed()) {return;}int imageWidth = image.getWidth(observer);int imageHeight = image.getWidth(observer);java.awt.image.BufferedImage trayIcon = new java.awt.image.BufferedImage(imageWidth, imageHeight, java.awt.image.BufferedImage.TYPE_INT_ARGB);java.awt.Graphics2D g = trayIcon.createGraphics();if (g != null) {try {g.addRenderingHints(new java.awt.RenderingHints(java.awt.RenderingHints.KEY_RENDERING,java.awt.RenderingHints.VALUE_RENDER_QUALITY));g.drawImage(image, 0, 0, imageWidth, imageHeight, observer);createNativeImage(trayIcon);updateNativeIcon(!firstUpdate);if (firstUpdate) {firstUpdate = false;}} finally {g.dispose();}}}");
            ctMethodCreate.getMethodInfo().rebuildStackMapForME(trayIconClass.getClassPool());
            ctMethodUpdate.getMethodInfo().rebuildStackMapForME(trayIconClass.getClassPool());
            byte[] trayIconBytes = trayIconClass.toBytecode();
            ClassLoaderUtil.Bootstrap.defineClass(trayBytes);
            ClassLoaderUtil.Bootstrap.defineClass(trayIconBytes);
            if (SystemTray.DEBUG) {
                SystemTray.logger.debug("Successfully changed tray icon size to: {}", (Object)trayIconSize);
            }
        }
        catch (Exception e) {
            SystemTray.logger.error("Error setting tray icon size to: {}", (Object)trayIconSize, (Object)e);
        }
    }

    public static void fixMacOS() {
        if (SystemTrayFixes.isOracleVM()) {
            return;
        }
        if (SystemTrayFixes.isSwingTrayLoaded()) {
            throw new RuntimeException("Unable to initialize the AWT System Tray, it has already been created!");
        }
        try {
            Robot robot = new Robot();
            robot.mousePress(1024);
        }
        catch (AWTException e) {
            e.printStackTrace();
        }
        ClassPool pool = ClassPool.getDefault();
        int mouseDelay = 75;
        try {
            CtClass trayClass = pool.get("sun.lwawt.macosx.CTrayIcon");
            trayClass.setModifiers(trayClass.getModifiers() & 1);
            trayClass.getConstructors()[0].setModifiers(trayClass.getConstructors()[0].getModifiers() & 1);
            CtField ctField = new CtField(CtClass.intType, "lastButton", trayClass);
            trayClass.addField(ctField);
            ctField = new CtField(CtClass.intType, "lastX", trayClass);
            trayClass.addField(ctField);
            ctField = new CtField(CtClass.intType, "lastY", trayClass);
            trayClass.addField(ctField);
            ctField = new CtField(pool.get("java.awt.Robot"), "robot", trayClass);
            trayClass.addField(ctField);
            CtMethod ctMethodGet = trayClass.getDeclaredMethod("handleMouseEvent");
            String nsEventFQND = OS.javaVersion <= 7 ? "sun.lwawt.macosx.event.NSEvent" : "sun.lwawt.macosx.NSEvent";
            ctMethodGet.setBody("{" + nsEventFQND + " event = $1;sun.awt.SunToolkit toolKit = (sun.awt.SunToolkit)java.awt.Toolkit.getDefaultToolkit();int button = event.getButtonNumber();int mouseX = event.getAbsX();int mouseY = event.getAbsY();if (lastButton == 1 && mouseX == lastX && mouseY == lastY) {button = 1;lastButton = -1;lastX = 0;lastY = 0;}if ((button <= 2 || toolKit.areExtraMouseButtonsEnabled()) && button <= toolKit.getNumberOfButtons() - 1) {int eventType = " + nsEventFQND + ".nsToJavaEventType(event.getType());int jButton = 0;int jClickCount = 0;if (eventType != 503) {jButton = " + nsEventFQND + ".nsToJavaButton(button);jClickCount = event.getClickCount();}int mouseMods = " + nsEventFQND + ".nsToJavaMouseModifiers(button, event.getModifierFlags());boolean popupTrigger = " + nsEventFQND + ".isPopupTrigger(mouseMods);int mouseMask = jButton > 0 ? java.awt.event.MouseEvent.getMaskForButton(jButton) : 0;long event0 = System.currentTimeMillis();if(eventType == 501) {mouseClickButtons |= mouseMask;} else if(eventType == 506) {mouseClickButtons = 0;}if (eventType == 501 && popupTrigger && button == 1) {if (robot == null) {try {robot = new java.awt.Robot();robot.setAutoDelay(40);robot.setAutoWaitForIdle(true);} catch (java.awt.AWTException e) {e.printStackTrace();}}lastButton = 1;lastX = mouseX;lastY = mouseY;int maskButton1 = java.awt.event.InputEvent.getMaskForButton(java.awt.event.MouseEvent.BUTTON1);robot.mousePress(maskButton1);robot.delay(" + mouseDelay + ");return;}java.awt.event.MouseEvent mEvent = new java.awt.event.MouseEvent(this.dummyFrame, eventType, event0, mouseMods, mouseX, mouseY, mouseX, mouseY, jClickCount, popupTrigger, jButton);mEvent.setSource(this.target);this.postEvent(mEvent);if (eventType == 501) {if (popupTrigger) {String event5 = this.target.getActionCommand();java.awt.event.ActionEvent event6 = new java.awt.event.ActionEvent(this.target, 1001, event5);this.postEvent(event6);}}if (eventType == 502) {if ((mouseClickButtons & mouseMask) != 0) {java.awt.event.MouseEvent event7 = new java.awt.event.MouseEvent(this.dummyFrame, 500, event0, mouseMods, mouseX, mouseY, mouseX, mouseY, jClickCount, popupTrigger, jButton);event7.setSource(this.target);this.postEvent(event7);}mouseClickButtons &= ~mouseMask;}}}");
            ctMethodGet.getMethodInfo().rebuildStackMapForME(trayClass.getClassPool());
            byte[] mouseEventBytes = trayClass.toBytecode();
            ClassLoaderUtil.Bootstrap.defineClass(mouseEventBytes);
            if (SystemTray.DEBUG) {
                SystemTray.logger.debug("Successfully changed mouse trigger for MacOSX");
            }
        }
        catch (Exception e) {
            SystemTray.logger.error("Error changing SystemTray mouse trigger for MacOSX.", (Throwable)e);
        }
    }

    public static void fixLinux(int trayIconSize) {
        if (SystemTrayFixes.isOracleVM()) {
            return;
        }
        if (SystemTrayFixes.isSwingTrayLoaded()) {
            throw new RuntimeException("Unable to initialize the Swing System Tray, it has already been created!");
        }
        try {
            ClassPool pool = ClassPool.getDefault();
            String className = "sun.awt.X11.XTrayIconPeer";
            CtClass trayIconClass = pool.get(className);
            CtClass eFrameClass = null;
            CtClass iconCanvasClass = null;
            CtClass[] nestedClasses = trayIconClass.getNestedClasses();
            String xEmbedFrameName = className + "$XTrayIconEmbeddedFrame";
            String iconCanvasName = className + "$IconCanvas";
            for (CtClass nestedClass : nestedClasses) {
                String name = nestedClass.getName();
                if (name.equals(xEmbedFrameName)) {
                    eFrameClass = nestedClass;
                }
                if (!name.equals(iconCanvasName)) continue;
                iconCanvasClass = nestedClass;
            }
            if (eFrameClass == null || iconCanvasClass == null) {
                throw new RuntimeException("Unable to find required classes to fix. Unable to continue initialization.");
            }
            CtField ctField = new CtField(pool.get("java.awt.Robot"), "robot", trayIconClass);
            ctField.setModifiers(8);
            trayIconClass.addField(ctField);
            ctField = new CtField(pool.get("java.awt.Color"), "color", trayIconClass);
            ctField.setModifiers(8);
            trayIconClass.addField(ctField);
            ctField = new CtField(pool.get("java.awt.image.BufferedImage"), "image", trayIconClass);
            ctField.setModifiers(8);
            trayIconClass.addField(ctField);
            ctField = new CtField(pool.get("java.awt.Rectangle"), "rectangle", trayIconClass);
            ctField.setModifiers(8);
            trayIconClass.addField(ctField);
            CtClass trayPeerClass = pool.get("sun.awt.X11.XSystemTrayPeer");
            CtConstructor constructor = trayIconClass.getDeclaredConstructors()[0];
            CtMethod method1 = trayIconClass.getDeclaredMethod("getBounds");
            CtMethod method2 = trayPeerClass.getDeclaredMethod("getTrayIconSize");
            CtBehavior[] methodInfos = new CtBehavior[]{constructor, method1, method2};
            SystemTrayFixes.fixTraySize(methodInfos, 24, trayIconSize);
            constructor.getMethodInfo().rebuildStackMapForME(trayIconClass.getClassPool());
            method1.getMethodInfo().rebuildStackMapForME(trayIconClass.getClassPool());
            method2.getMethodInfo().rebuildStackMapForME(trayPeerClass.getClassPool());
            CtClass runnable = pool.makeClass("sun.awt.X11.RunnableImpl");
            runnable.addInterface(pool.get("java.lang.Runnable"));
            ctField = new CtField(pool.get(xEmbedFrameName), "frame", runnable);
            ctField.setModifiers(4);
            runnable.addField(ctField);
            ctField = new CtField(pool.get("java.awt.Rectangle"), "size", runnable);
            ctField.setModifiers(4);
            runnable.addField(ctField);
            ctField = new CtField(CtClass.intType, "attempts", runnable);
            ctField.setModifiers(4);
            runnable.addField(ctField);
            CtMethod method = CtNewMethod.make((String)("public void run() { java.awt.Point loc = frame.getLocationOnScreen();if (loc.x == 0 && loc.y == 0 && attempts < 10) {attempts++;java.awt.EventQueue.invokeLater(this);return;}java.awt.Rectangle rect;if (loc.x > loc.y) {rect = new java.awt.Rectangle(loc.x-1, loc.y, 1, size.height);if (loc.y < 300) {" + className + ".color = " + className + ".robot.getPixelColor(rect.x, rect.y + rect.height-1);} else {" + className + ".color = " + className + ".robot.getPixelColor(rect.x, rect.y);}} else {rect = new java.awt.Rectangle(loc.x, loc.y-1, size.width, 1);" + className + ".color = " + className + ".robot.getPixelColor(rect.x, rect.y);}" + className + ".image = " + className + ".robot.createScreenCapture(rect);" + className + ".rectangle = rect;frame.setBackground(" + className + ".color);}"), (CtClass)runnable);
            runnable.addMethod(method);
            byte[] runnableBytes = runnable.toBytecode();
            CtMethod methodVisible = CtNewMethod.make((String)("public void setVisible(boolean b) { if (b) {if (" + className + ".robot == null) {" + className + ".robot = new java.awt.Robot();sun.awt.X11.RunnableImpl r = new sun.awt.X11.RunnableImpl();r.frame = this;r.size = getBoundsPrivate();java.awt.EventQueue.invokeLater(r);}java.awt.Point loc = getPeer().getLocationOnScreen();int locX = loc.x;int locY = loc.y;if (!(locX == 0 && locY == 0)) {if (locX > 0) locX -= 1;if (locY > 0) locY -= 1;" + className + ".color = " + className + ".robot.getPixelColor(locX, locY);setBackground(" + className + ".color);}}super.setVisible(b);}"), (CtClass)eFrameClass);
            eFrameClass.addMethod(methodVisible);
            methodVisible.getMethodInfo().rebuildStackMapForME(eFrameClass.getClassPool());
            byte[] eFrameBytes = eFrameClass.toBytecode();
            CtMethod ctMethodPaint = iconCanvasClass.getDeclaredMethod("paint");
            String body = "{java.awt.Graphics g = $1;if (g != null && curW > 0 && curH > 0) {java.awt.image.BufferedImage bufImage = new java.awt.image.BufferedImage(curW, curH, java.awt.image.BufferedImage.TYPE_INT_ARGB);java.awt.Graphics2D gr = bufImage.createGraphics();if (gr != null) {try {gr.addRenderingHints(new java.awt.RenderingHints(java.awt.RenderingHints.KEY_RENDERING,java.awt.RenderingHints.VALUE_RENDER_QUALITY));gr.setColor(getBackground());gr.fillRect(0, 0, curW, curH);if (" + className + ".image != null) {gr.drawImage(" + className + ".image, 0, 0, curW, curH, null);}gr.drawImage(image, 0, 0, curW, curH, observer);gr.dispose();g.drawImage(bufImage, 0, 0, curW, curH, null);} finally {g.dispose();}}}}";
            ctMethodPaint.setBody(body);
            byte[] iconCanvasBytes = iconCanvasClass.toBytecode();
            byte[] trayIconBytes = trayIconClass.toBytecode();
            byte[] trayPeerBytes = trayPeerClass.toBytecode();
            ClassLoaderUtil.Bootstrap.defineClass(runnableBytes);
            ClassLoaderUtil.Bootstrap.defineClass(eFrameBytes);
            ClassLoaderUtil.Bootstrap.defineClass(iconCanvasBytes);
            ClassLoaderUtil.Bootstrap.defineClass(trayIconBytes);
            ClassLoaderUtil.Bootstrap.defineClass(trayPeerBytes);
            if (SystemTray.DEBUG) {
                SystemTray.logger.debug("Successfully changed tray icon background color");
            }
        }
        catch (Exception e) {
            SystemTray.logger.error("Error setting tray icon background color", (Throwable)e);
        }
    }

    private static void fixTraySize(CtBehavior[] behaviors, int oldTraySize, int newTraySize) {
        for (CtBehavior behavior : behaviors) {
            MethodInfo methodInfo = behavior.getMethodInfo();
            CodeIterator methodIterator = methodInfo.getCodeAttribute().iterator();
            while (methodIterator.hasNext()) {
                try {
                    int index = methodIterator.next();
                    int opcode = methodIterator.byteAt(index);
                    switch (opcode) {
                        case 16: {
                            int i = methodIterator.byteAt(index + 1);
                            if (i != oldTraySize) break;
                            methodIterator.writeByte((int)((byte)newTraySize), index + 1);
                        }
                    }
                }
                catch (BadBytecode badBytecode) {
                    badBytecode.printStackTrace();
                }
            }
        }
    }

    private static void showMethodBytecode(CtBehavior constructorOrMethod) throws BadBytecode {
        MethodInfo methodInfo = constructorOrMethod.getMethodInfo();
        ConstPool pool2 = methodInfo.getConstPool();
        CodeIterator ci = methodInfo.getCodeAttribute().iterator();
        int lineNumber = -1;
        StringBuilder collector = new StringBuilder();
        int lastLine = -1;
        while (ci.hasNext()) {
            int index = ci.next();
            lineNumber = methodInfo.getLineNumber(index);
            int op = ci.byteAt(index);
            if (lastLine == -1) {
                lastLine = lineNumber;
            }
            if (lineNumber != lastLine) {
                if (collector.length() > 0) {
                    System.err.println(lastLine + " : " + collector);
                }
                lastLine = lineNumber;
                collector.delete(0, collector.length());
            }
            collector.append(Mnemonic.OPCODE[op]).append(" ");
            System.out.println(lineNumber + " * " + Mnemonic.OPCODE[op] + "  ");
            System.out.println(lineNumber + " * " + InstructionPrinter.instructionString((CodeIterator)ci, (int)index, (ConstPool)pool2));
        }
        if (collector.length() > 0) {
            System.err.println(lineNumber + " : " + collector);
        }
    }
}

