/*
 * Decompiled with CFR 0.152.
 */
package dorkbox.systemTray.util;

import dorkbox.systemTray.SystemTray;
import dorkbox.systemTray.util.SizeAndScalingUtil;
import dorkbox.util.CacheUtil;
import dorkbox.util.IO;
import dorkbox.util.ImageUtil;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import javax.imageio.ImageIO;
import javax.imageio.stream.ImageInputStream;

public class ImageResizeUtil {
    public static File getTransparentImage() {
        return ImageResizeUtil.getTransparentImage(4);
    }

    public static File getTransparentImage(int imageSize) {
        try {
            File newFile = CacheUtil.create(imageSize + "_empty.png");
            return ImageUtil.createImage(imageSize, newFile, null);
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to generate transparent image! Something is severely wrong!");
        }
    }

    public static File getErrorImage(int size) {
        if (size == 0) {
            size = 32;
        }
        try {
            InputStream imageStream = ImageResizeUtil.class.getResource("error_32.png").openStream();
            imageStream = ImageResizeUtil.makeByteArrayInputStream(imageStream);
            imageStream.mark(0);
            String cacheName = size + "_" + CacheUtil.createNameAsHash(imageStream);
            ((ByteArrayInputStream)imageStream).reset();
            File check = CacheUtil.check(cacheName);
            if (check != null) {
                return check;
            }
            File resizedFile = ImageResizeUtil.resizeFileNoCheck(size, imageStream);
            return CacheUtil.save(cacheName, resizedFile);
        }
        catch (Exception e) {
            throw new RuntimeException("Serious problems! Unable to extract error image, this should NEVER happen!", e);
        }
    }

    private static synchronized File resizeAndCache(int size, File file) {
        return ImageResizeUtil.resizeAndCache(size, file.getAbsolutePath());
    }

    private static synchronized File resizeAndCache(int size, String fileName) {
        if (fileName == null) {
            return null;
        }
        try {
            FileInputStream fileInputStream = new FileInputStream(fileName);
            File file = ImageResizeUtil.resizeAndCache(size, fileInputStream);
            fileInputStream.close();
            return file;
        }
        catch (Exception e) {
            SystemTray.logger.error("Error reading image. Using error icon instead", (Throwable)e);
            return ImageResizeUtil.getErrorImage(size);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static synchronized File resizeAndCache(int size, InputStream imageStream) {
        String cacheName;
        if (imageStream == null) {
            return null;
        }
        boolean needsResize = true;
        try {
            imageStream = ImageResizeUtil.makeByteArrayInputStream(imageStream);
            imageStream.mark(0);
            cacheName = size + "_" + CacheUtil.createNameAsHash(imageStream);
            ((ByteArrayInputStream)imageStream).reset();
            File check = CacheUtil.check(cacheName);
            if (check != null) {
                File file = check;
                return file;
            }
            imageStream.mark(0);
            Dimension imageSize = ImageUtil.getImageSize(imageStream);
            if (size == (int)imageSize.getHeight() && size == (int)imageSize.getWidth()) {
                needsResize = false;
            }
        }
        catch (Exception e) {
            SystemTray.logger.error("Error getting image size. Using error icon instead", (Throwable)e);
            File imageSize = ImageResizeUtil.getErrorImage(size);
            return imageSize;
        }
        finally {
            ((ByteArrayInputStream)imageStream).reset();
        }
        if (needsResize) {
            try {
                File resizedFile = ImageResizeUtil.resizeFileNoCheck(size, imageStream);
                try {
                    return CacheUtil.save(cacheName, resizedFile);
                }
                catch (Exception e) {
                    SystemTray.logger.error("Error caching image. Using error icon instead", (Throwable)e);
                    return ImageResizeUtil.getErrorImage(size);
                }
            }
            catch (Exception e) {
                SystemTray.logger.error("Error resizing image. Using error icon instead", (Throwable)e);
                return ImageResizeUtil.getErrorImage(size);
            }
        }
        try {
            return CacheUtil.save(cacheName, imageStream);
        }
        catch (Exception e) {
            SystemTray.logger.error("Error caching image. Using error icon instead", (Throwable)e);
            return ImageResizeUtil.getErrorImage(size);
        }
    }

    private static InputStream makeByteArrayInputStream(InputStream imageStream) throws IOException {
        if (!(imageStream instanceof ByteArrayInputStream)) {
            ByteArrayOutputStream byteArrayOutputStream = IO.copyStream(imageStream);
            imageStream.close();
            imageStream = new ByteArrayInputStream(byteArrayOutputStream.toByteArray());
        }
        return imageStream;
    }

    private static File resizeFileNoCheck(int size, InputStream inputStream) throws IOException {
        File newFile = CacheUtil.create("temp_resize.png");
        newFile.delete();
        Image image = ImageUtil.getImageImmediate(ImageIO.read(inputStream));
        BufferedImage bufferedImage = ImageUtil.getBufferedImage(image);
        int width = bufferedImage.getWidth();
        int height = bufferedImage.getHeight();
        bufferedImage = width > height ? ImageUtil.resizeImage(bufferedImage, size, -1) : ImageUtil.resizeImage(bufferedImage, -1, size);
        bufferedImage = ImageUtil.getSquareBufferedImage(bufferedImage);
        ImageIO.write((RenderedImage)bufferedImage, "png", newFile);
        return newFile;
    }

    public static File shouldResizeOrCache(boolean isTrayImage, File imageFile) {
        if (imageFile == null) {
            return null;
        }
        if (SystemTray.AUTO_SIZE) {
            return ImageResizeUtil.resizeAndCache(ImageResizeUtil.getSize(isTrayImage), imageFile);
        }
        return imageFile;
    }

    public static File shouldResizeOrCache(boolean isTrayImage, String imagePath) {
        if (imagePath == null) {
            return null;
        }
        if (SystemTray.AUTO_SIZE) {
            return ImageResizeUtil.resizeAndCache(ImageResizeUtil.getSize(isTrayImage), imagePath);
        }
        return new File(imagePath);
    }

    public static File shouldResizeOrCache(boolean isTrayImage, URL imageUrl) {
        if (imageUrl == null) {
            return null;
        }
        try {
            if (SystemTray.AUTO_SIZE) {
                InputStream inputStream = imageUrl.openStream();
                File file = ImageResizeUtil.resizeAndCache(ImageResizeUtil.getSize(isTrayImage), inputStream);
                inputStream.close();
                return file;
            }
            return CacheUtil.save(imageUrl);
        }
        catch (Exception e) {
            SystemTray.logger.error("Error reading image. Using error icon instead", (Throwable)e);
            return ImageResizeUtil.getErrorImage(ImageResizeUtil.getSize(isTrayImage));
        }
    }

    public static File shouldResizeOrCache(boolean isTrayImage, InputStream imageStream) {
        if (imageStream == null) {
            return null;
        }
        if (SystemTray.AUTO_SIZE) {
            return ImageResizeUtil.resizeAndCache(ImageResizeUtil.getSize(isTrayImage), imageStream);
        }
        try {
            return CacheUtil.save(imageStream);
        }
        catch (IOException e) {
            SystemTray.logger.error("Error checking cache for information. Using error icon instead", (Throwable)e);
            return ImageResizeUtil.getErrorImage(0);
        }
    }

    public static File shouldResizeOrCache(boolean isTrayImage, Image image) {
        if (image == null) {
            return null;
        }
        try {
            Image trayImage = ImageUtil.getImageImmediate(image);
            BufferedImage bufferedImage = ImageUtil.getBufferedImage(trayImage);
            ByteArrayOutputStream os = new ByteArrayOutputStream();
            ImageIO.write((RenderedImage)bufferedImage, "png", os);
            ByteArrayInputStream imageInputStream = new ByteArrayInputStream(os.toByteArray());
            if (SystemTray.AUTO_SIZE) {
                File file = ImageResizeUtil.resizeAndCache(ImageResizeUtil.getSize(isTrayImage), imageInputStream);
                ((InputStream)imageInputStream).close();
                return file;
            }
            File file = CacheUtil.save(imageInputStream);
            ((InputStream)imageInputStream).close();
            return file;
        }
        catch (Exception e) {
            SystemTray.logger.error("Error reading image. Using error icon instead", (Throwable)e);
            return ImageResizeUtil.getErrorImage(ImageResizeUtil.getSize(isTrayImage));
        }
    }

    public static File shouldResizeOrCache(boolean isTrayImage, ImageInputStream imageStream) {
        if (imageStream == null) {
            return null;
        }
        try {
            ByteArrayOutputStream byteArrayOutputStream = IO.copyStream(imageStream);
            ByteArrayInputStream fileStream = new ByteArrayInputStream(byteArrayOutputStream.toByteArray());
            if (SystemTray.AUTO_SIZE) {
                return ImageResizeUtil.resizeAndCache(ImageResizeUtil.getSize(isTrayImage), fileStream);
            }
            return CacheUtil.save(fileStream);
        }
        catch (Exception e) {
            SystemTray.logger.error("Error reading image. Using error icon instead", (Throwable)e);
            return ImageResizeUtil.getErrorImage(ImageResizeUtil.getSize(isTrayImage));
        }
    }

    private static int getSize(boolean isTrayImage) {
        int size = isTrayImage ? SizeAndScalingUtil.TRAY_SIZE : SizeAndScalingUtil.TRAY_MENU_SIZE;
        return size;
    }
}

