/*
 * Decompiled with CFR 0.152.
 */
package dorkbox.systemTray.ui.swing;

import dorkbox.systemTray.Entry;
import dorkbox.systemTray.MenuItem;
import dorkbox.systemTray.SystemTray;
import dorkbox.systemTray.peer.MenuItemPeer;
import dorkbox.systemTray.ui.swing.SwingMenu;
import dorkbox.systemTray.util.EventDispatch;
import dorkbox.systemTray.util.ImageResizeUtil;
import dorkbox.util.SwingUtil;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.ImageIcon;
import javax.swing.JMenuItem;

class SwingMenuItem
implements MenuItemPeer {
    protected static ImageIcon transparentIcon;
    protected final SwingMenu parent;
    protected final JMenuItem _native = new JMenuItem();
    protected volatile ActionListener callback;

    SwingMenuItem(SwingMenu parent, Entry entry) {
        this.parent = parent;
        if (SystemTray.SWING_UI != null) {
            this._native.setUI(SystemTray.SWING_UI.getItemUI(this._native, entry));
        }
        this._native.setHorizontalAlignment(2);
        parent._native.add(this._native);
        if (transparentIcon == null) {
            try {
                JMenuItem jMenuItem = new JMenuItem();
                if (SystemTray.SWING_UI != null) {
                    jMenuItem.setUI(SystemTray.SWING_UI.getItemUI(jMenuItem, null));
                }
                int menuImageSize = SystemTray.get().getMenuImageSize();
                transparentIcon = new ImageIcon(ImageResizeUtil.getTransparentImage(menuImageSize).getAbsolutePath());
            }
            catch (Exception e) {
                SystemTray.logger.error("Error creating transparent image.", (Throwable)e);
            }
        }
        this._native.setIcon(transparentIcon);
    }

    @Override
    public void setImage(final MenuItem menuItem) {
        SwingUtil.invokeLater(new Runnable(){

            @Override
            public void run() {
                File imageFile = menuItem.getImage();
                if (imageFile != null) {
                    ImageIcon origIcon = new ImageIcon(imageFile.getAbsolutePath());
                    SwingMenuItem.this._native.setIcon(origIcon);
                } else {
                    SwingMenuItem.this._native.setIcon(transparentIcon);
                }
            }
        });
    }

    @Override
    public void setEnabled(final MenuItem menuItem) {
        SwingUtil.invokeLater(new Runnable(){

            @Override
            public void run() {
                SwingMenuItem.this._native.setEnabled(menuItem.getEnabled());
            }
        });
    }

    @Override
    public void setText(final MenuItem menuItem) {
        SwingUtil.invokeLater(new Runnable(){

            @Override
            public void run() {
                SwingMenuItem.this._native.setText(menuItem.getText());
            }
        });
    }

    @Override
    public void setCallback(final MenuItem menuItem) {
        if (this.callback != null) {
            this._native.removeActionListener(this.callback);
        }
        this.callback = menuItem.getCallback();
        if (this.callback != null) {
            this.callback = new ActionListener(){
                final ActionListener cb;
                {
                    this.cb = menuItem.getCallback();
                }

                @Override
                public void actionPerformed(ActionEvent e) {
                    EventDispatch.runLater(new Runnable(){

                        @Override
                        public void run() {
                            try {
                                cb.actionPerformed(new ActionEvent(menuItem, 1001, ""));
                            }
                            catch (Throwable throwable) {
                                SystemTray.logger.error("Error calling menu entry {} click event.", (Object)menuItem.getText(), (Object)throwable);
                            }
                        }
                    });
                }
            };
            this._native.addActionListener(this.callback);
        }
    }

    @Override
    public void setShortcut(MenuItem menuItem) {
        char shortcut = menuItem.getShortcut();
        final int vKey = SwingUtil.getVirtualKey(shortcut);
        SwingUtil.invokeLater(new Runnable(){

            @Override
            public void run() {
                SwingMenuItem.this._native.setMnemonic(vKey);
            }
        });
    }

    @Override
    public void setTooltip(final MenuItem menuItem) {
        SwingUtil.invokeLater(new Runnable(){

            @Override
            public void run() {
                SwingMenuItem.this._native.setToolTipText(menuItem.getTooltip());
            }
        });
    }

    @Override
    public void remove() {
        SwingUtil.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (SwingMenuItem.this.callback != null) {
                    SwingMenuItem.this._native.removeActionListener(SwingMenuItem.this.callback);
                    SwingMenuItem.this.callback = null;
                }
                SwingMenuItem.this.parent._native.remove(SwingMenuItem.this._native);
                SwingMenuItem.this._native.removeAll();
            }
        });
    }
}

