/*
 * Decompiled with CFR 0.152.
 */
package dorkbox.systemTray.ui.awt;

import dorkbox.systemTray.MenuItem;
import dorkbox.systemTray.SystemTray;
import dorkbox.systemTray.Tray;
import dorkbox.systemTray.ui.awt.AwtMenu;
import dorkbox.util.OS;
import dorkbox.util.SwingUtil;
import java.awt.AWTException;
import java.awt.Image;
import java.awt.PopupMenu;
import java.awt.TrayIcon;
import java.io.File;
import javax.swing.ImageIcon;

public final class _AwtTray
extends Tray {
    private volatile java.awt.SystemTray tray;
    private volatile TrayIcon trayIcon;
    private volatile boolean visible = true;
    private volatile File imageFile;
    private volatile String tooltipText = "";
    private final Object keepAliveLock = new Object[0];
    private Thread keepAliveThread;

    public _AwtTray(SystemTray systemTray) {
        if (!java.awt.SystemTray.isSupported()) {
            throw new RuntimeException("System Tray is not supported in this configuration! Please write an issue and include your OS type and configuration");
        }
        AwtMenu awtMenu = new AwtMenu(null){

            @Override
            public void setEnabled(final MenuItem menuItem) {
                SwingUtil.invokeLater(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        if (_AwtTray.this.tray == null) {
                            _AwtTray.this.tray = java.awt.SystemTray.getSystemTray();
                        }
                        boolean enabled = menuItem.getEnabled();
                        if (OS.isMacOsX()) {
                            if (_AwtTray.this.keepAliveThread != null) {
                                Object object = _AwtTray.this.keepAliveLock;
                                synchronized (object) {
                                    _AwtTray.this.keepAliveLock.notifyAll();
                                }
                            }
                            _AwtTray.this.keepAliveThread = null;
                            if (_AwtTray.this.visible && !enabled) {
                                _AwtTray.this.keepAliveThread = new Thread(new Runnable(){

                                    /*
                                     * WARNING - Removed try catching itself - possible behaviour change.
                                     */
                                    @Override
                                    public void run() {
                                        Object object = _AwtTray.this.keepAliveLock;
                                        synchronized (object) {
                                            _AwtTray.this.keepAliveLock.notifyAll();
                                            try {
                                                _AwtTray.this.keepAliveLock.wait();
                                            }
                                            catch (InterruptedException interruptedException) {
                                                // empty catch block
                                            }
                                        }
                                    }
                                }, "TrayKeepAliveThread");
                                _AwtTray.this.keepAliveThread.start();
                            }
                        }
                        if (_AwtTray.this.visible && !enabled) {
                            _AwtTray.this.tray.remove(_AwtTray.this.trayIcon);
                            _AwtTray.this.visible = false;
                        } else if (!_AwtTray.this.visible && enabled) {
                            try {
                                _AwtTray.this.tray.add(_AwtTray.this.trayIcon);
                                _AwtTray.this.visible = true;
                                _AwtTray.this.trayIcon.setToolTip(_AwtTray.this.tooltipText);
                            }
                            catch (AWTException e) {
                                SystemTray.logger.error("Error adding the icon back to the tray", (Throwable)e);
                            }
                        }
                    }
                });
            }

            @Override
            public void setImage(MenuItem menuItem) {
                _AwtTray.this.imageFile = menuItem.getImage();
                if (_AwtTray.this.imageFile == null) {
                    return;
                }
                SwingUtil.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        if (_AwtTray.this.tray == null) {
                            _AwtTray.this.tray = java.awt.SystemTray.getSystemTray();
                        }
                        Image trayImage = new ImageIcon(_AwtTray.this.imageFile.getAbsolutePath()).getImage();
                        trayImage.flush();
                        if (_AwtTray.this.trayIcon == null) {
                            _AwtTray.this.trayIcon = new TrayIcon(trayImage);
                            _AwtTray.this.trayIcon.setPopupMenu((PopupMenu)_native);
                            try {
                                _AwtTray.this.tray.add(_AwtTray.this.trayIcon);
                            }
                            catch (AWTException e) {
                                SystemTray.logger.error("TrayIcon could not be added.", (Throwable)e);
                            }
                        } else {
                            _AwtTray.this.trayIcon.setImage(trayImage);
                        }
                        _AwtTray.this.trayIcon.setToolTip(_AwtTray.this.tooltipText);
                    }
                });
            }

            @Override
            public void setText(MenuItem menuItem) {
            }

            @Override
            public void setShortcut(MenuItem menuItem) {
            }

            @Override
            public void setTooltip(MenuItem menuItem) {
                final String text = menuItem.getTooltip();
                if (_AwtTray.this.tooltipText != null && _AwtTray.this.tooltipText.equals(text) || _AwtTray.this.tooltipText == null && text != null) {
                    return;
                }
                _AwtTray.this.tooltipText = text;
                SwingUtil.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        if (_AwtTray.this.trayIcon != null) {
                            _AwtTray.this.trayIcon.setToolTip(text);
                        }
                    }
                });
            }

            @Override
            public void remove() {
                SwingUtil.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        if (_AwtTray.this.trayIcon != null) {
                            _AwtTray.this.trayIcon.setPopupMenu(null);
                            if (_AwtTray.this.tray != null) {
                                _AwtTray.this.tray.remove(_AwtTray.this.trayIcon);
                            }
                            _AwtTray.this.trayIcon = null;
                        }
                        _AwtTray.this.tray = null;
                    }
                });
                super.remove();
            }
        };
        this.bind(awtMenu, null, systemTray);
    }

    @Override
    public boolean hasImage() {
        return this.imageFile != null;
    }
}

