/*
 * Decompiled with CFR 0.152.
 */
package dorkbox.systemTray;

import dorkbox.systemTray.Menu;
import dorkbox.systemTray.Tray;
import dorkbox.systemTray.ui.awt._AwtTray;
import dorkbox.systemTray.ui.gtk._AppIndicatorNativeTray;
import dorkbox.systemTray.ui.gtk._GtkStatusIconNativeTray;
import dorkbox.systemTray.ui.swing.SwingUIFactory;
import dorkbox.systemTray.ui.swing._SwingTray;
import dorkbox.systemTray.ui.swing._WindowsNativeTray;
import dorkbox.systemTray.util.EventDispatch;
import dorkbox.systemTray.util.ImageResizeUtil;
import dorkbox.systemTray.util.LinuxSwingUI;
import dorkbox.systemTray.util.SizeAndScalingUtil;
import dorkbox.systemTray.util.SystemTrayFixes;
import dorkbox.systemTray.util.WindowsSwingUI;
import dorkbox.util.CacheUtil;
import dorkbox.util.JavaFX;
import dorkbox.util.OS;
import dorkbox.util.OSUtil;
import dorkbox.util.Property;
import dorkbox.util.SwingUtil;
import dorkbox.util.Swt;
import dorkbox.util.jna.linux.AppIndicator;
import dorkbox.util.jna.linux.Gtk;
import dorkbox.util.jna.linux.GtkCheck;
import dorkbox.util.jna.linux.GtkEventDispatch;
import java.awt.Component;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.InputStream;
import java.net.URL;
import java.util.concurrent.atomic.AtomicReference;
import javax.imageio.stream.ImageInputStream;
import javax.swing.Icon;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JSeparator;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SystemTray {
    public static final Logger logger = LoggerFactory.getLogger(SystemTray.class);
    @Property
    public static boolean AUTO_SIZE = true;
    @Property
    public static boolean FORCE_GTK2 = false;
    @Property
    public static boolean PREFER_GTK3 = true;
    @Property
    public static TrayType FORCE_TRAY_TYPE = TrayType.AutoDetect;
    @Property
    public static boolean ENABLE_SHUTDOWN_HOOK = true;
    @Property
    public static boolean AUTO_FIX_INCONSISTENCIES = true;
    @Property
    public static boolean ENABLE_ROOT_CHECK = true;
    @Property
    public static SwingUIFactory SWING_UI = null;
    @Property
    public static boolean DEBUG = false;
    private static volatile SystemTray systemTray = null;
    private static volatile Tray systemTrayMenu = null;

    private static boolean isTrayType(Class<? extends Tray> tray, TrayType trayType) {
        switch (trayType) {
            case GtkStatusIcon: {
                return tray == _GtkStatusIconNativeTray.class;
            }
            case AppIndicator: {
                return tray == _AppIndicatorNativeTray.class;
            }
            case WindowsNotifyIcon: {
                return tray == _WindowsNativeTray.class;
            }
            case Swing: {
                return tray == _SwingTray.class;
            }
            case AWT: {
                return tray == _AwtTray.class;
            }
        }
        return false;
    }

    private static Class<? extends Tray> selectType(TrayType trayType) throws Exception {
        if (trayType == TrayType.GtkStatusIcon) {
            return _GtkStatusIconNativeTray.class;
        }
        if (trayType == TrayType.AppIndicator) {
            return _AppIndicatorNativeTray.class;
        }
        if (trayType == TrayType.WindowsNotifyIcon) {
            return _WindowsNativeTray.class;
        }
        if (trayType == TrayType.Swing) {
            return _SwingTray.class;
        }
        if (trayType == TrayType.AWT) {
            return _AwtTray.class;
        }
        return null;
    }

    private static Class<? extends Tray> selectTypeQuietly(TrayType trayType) {
        try {
            return SystemTray.selectType(trayType);
        }
        catch (Throwable t) {
            if (DEBUG) {
                logger.error("Cannot initialize {}", (Object)trayType.name(), (Object)t);
            }
            return null;
        }
    }

    /*
     * Exception decompiling
     */
    private static Class<? extends Tray> getAutoDetectTrayType() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [22[CATCHBLOCK], 4[TRYBLOCK], 3[TRYBLOCK]], but top level block is 6[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static void init() {
        Class<? extends Tray> trayType;
        if (systemTray != null) {
            return;
        }
        if (GraphicsEnvironment.isHeadless()) {
            logger.error("Cannot use the SystemTray in a headless environment");
            systemTrayMenu = null;
            systemTray = null;
            return;
        }
        boolean isNix = OS.isLinux() || OS.isUnix();
        boolean isWindows = OS.isWindows();
        boolean isMacOsX = OS.isMacOsX();
        if (isWindows) {
            if (FORCE_TRAY_TYPE != TrayType.AutoDetect && FORCE_TRAY_TYPE != TrayType.Swing && FORCE_TRAY_TYPE != TrayType.WindowsNotifyIcon) {
                FORCE_TRAY_TYPE = TrayType.AutoDetect;
                logger.warn("Windows cannot use the '" + (Object)((Object)FORCE_TRAY_TYPE) + "' SystemTray type, defaulting to swing implementation");
            }
        } else if (isMacOsX) {
            if (JavaFX.isLoaded && OS.javaVersion <= 7 && !System.getProperty("javafx.macosx.embedded", "false").equals("true")) {
                logger.error("MacOSX JavaFX (Java7) is incompatible with the SystemTray by default. See issue: 'https://bugs.openjdk.java.net/browse/JDK-8116017'  and 'https://bugs.openjdk.java.net/browse/JDK-8118714'\nTo fix this do one of the following: \n - Upgrade to Java 8\n - Add : '-Djavafx.macosx.embedded=true' as a JVM parameter\n - Set the system property via 'System.setProperty(\"javafx.macosx.embedded\", \"true\");'  before JavaFX isinitialized, used, or accessed. NOTE: You may need to change the class (that your main method is in) so it does NOT extend the JavaFX 'Application' class.");
                systemTrayMenu = null;
                systemTray = null;
                return;
            }
            if (Swt.isLoaded) {
                if (Swt.getVersion() < 4430) {
                    logger.error("Unable to use currently loaded version of SWT, it is TOO OLD. Please use version 4.4+");
                    systemTrayMenu = null;
                    systemTray = null;
                    return;
                }
                if (FORCE_TRAY_TYPE == TrayType.Swing) {
                    if (AUTO_FIX_INCONSISTENCIES) {
                        logger.warn("Unable to load Swing + SWT (for all versions of Java). Using the AWT Tray type instead.");
                        FORCE_TRAY_TYPE = TrayType.AWT;
                    } else {
                        logger.error("Unable to load Swing + SWT (for all versions of Java). Please set `SystemTray.AUTO_FIX_INCONSISTENCIES=true;` to automatically fix this problem.\"");
                        systemTrayMenu = null;
                        systemTray = null;
                        return;
                    }
                }
            }
            if (FORCE_TRAY_TYPE != TrayType.AutoDetect && FORCE_TRAY_TYPE != TrayType.Swing && FORCE_TRAY_TYPE != TrayType.AWT) {
                FORCE_TRAY_TYPE = TrayType.AutoDetect;
                logger.warn("MacOS cannot use the '" + (Object)((Object)FORCE_TRAY_TYPE) + "' SystemTray type, defaulting to the AWT Tray type instead.");
            }
        } else if (isNix) {
            int loadedGtkVersion = GtkCheck.getLoadedGtkVersion();
            if (loadedGtkVersion == 2) {
                if (AUTO_FIX_INCONSISTENCIES) {
                    if (!FORCE_GTK2) {
                        if (JavaFX.isLoaded) {
                            FORCE_GTK2 = true;
                            if (DEBUG) {
                                logger.debug("Forcing GTK2 because JavaFX is GTK2");
                            }
                        } else if (Swt.isLoaded) {
                            FORCE_GTK2 = true;
                            if (DEBUG) {
                                logger.debug("Forcing GTK2 because SWT is GTK2");
                            }
                        } else {
                            FORCE_GTK2 = true;
                            if (DEBUG) {
                                logger.debug("Forcing GTK2 because Java has already loaded GTK2");
                            }
                        }
                    }
                } else if (!FORCE_GTK2) {
                    logger.error("Unable to use the SystemTray when there is a mismatch for GTK loaded preferences. Please correctly set `SystemTray.FORCE_GTK2=true` or set `SystemTray.AUTO_FIX_INCONSISTENCIES=true`.  Aborting...");
                    systemTrayMenu = null;
                    systemTray = null;
                    return;
                }
            } else if (loadedGtkVersion == 3) {
                if (AUTO_FIX_INCONSISTENCIES) {
                    if (JavaFX.isLoaded) {
                        if (FORCE_GTK2 && OS.javaVersion == 9) {
                            FORCE_GTK2 = false;
                            logger.warn("Unable to use the SystemTray when JavaFX is configured to use GTK3 and the SystemTray is configured to use GTK2. Please configure JavaFX to use GTK2 (via `System.setProperty(\"jdk.gtk.version\", \"3\");`) before JavaFX is initialized, or set `SystemTray.FORCE_GTK2=false;`  Undoing `FORCE_GTK2`.");
                        }
                        if (!PREFER_GTK3) {
                            PREFER_GTK3 = true;
                            if (DEBUG) {
                                logger.debug("Preferring GTK3 even though specified otherwise, because JavaFX is GTK3");
                            }
                        }
                    } else if (Swt.isLoaded) {
                        if (FORCE_GTK2) {
                            FORCE_GTK2 = false;
                            logger.warn("Unable to use the SystemTray when SWT is configured to use GTK3 and the SystemTray is configured to use GTK2. Please configure SWT to use GTK2, via `System.setProperty(\"SWT_GTK3\", \"0\");` before SWT is initialized, or set `SystemTray.FORCE_GTK2=false;`");
                        }
                        if (!PREFER_GTK3) {
                            PREFER_GTK3 = true;
                            if (DEBUG) {
                                logger.debug("Preferring GTK3 even though specified otherwise, because SWT is GTK3");
                            }
                        }
                    } else {
                        if (FORCE_GTK2) {
                            FORCE_GTK2 = false;
                            logger.warn("Unable to use the SystemTray when Swing is configured to use GTK3 and the SystemTray is configured to use GTK2. Undoing `FORCE_GTK2.");
                        }
                        if (!PREFER_GTK3) {
                            PREFER_GTK3 = true;
                            if (DEBUG) {
                                logger.debug("Preferring GTK3 even though specified otherwise, because Java has already loaded GTK3");
                            }
                        }
                    }
                } else if (JavaFX.isLoaded) {
                    if (FORCE_GTK2) {
                        if (OS.javaVersion == 9) {
                            logger.error("Unable to use the SystemTray when JavaFX is configured to use GTK3 and the SystemTray is configured to use GTK2. Please configure JavaFX to use GTK2 (via `System.setProperty(\"jdk.gtk.version\", \"3\");`) before JavaFX is initialized, or set `SystemTray.FORCE_GTK2=false;`  Aborting.");
                        } else {
                            logger.error("Unable to use the SystemTray when JavaFX is configured to use GTK3 and the SystemTray is configured to use GTK2. Please set `SystemTray.FORCE_GTK2=false;`  Aborting.");
                        }
                        systemTrayMenu = null;
                        systemTray = null;
                        return;
                    }
                } else if (Swt.isLoaded) {
                    if (FORCE_GTK2) {
                        logger.error("Unable to use the SystemTray when SWT is configured to use GTK3 and the SystemTray is configured to use GTK2. Please configure SWT to use GTK2, via `System.setProperty(\"SWT_GTK3\", \"0\");` before SWT is initialized, or set `SystemTray.FORCE_GTK2=false;`");
                        systemTrayMenu = null;
                        systemTray = null;
                        return;
                    }
                } else if (FORCE_GTK2) {
                    logger.error("Unable to use the SystemTray when Swing is configured to use GTK3 and the SystemTray is configured to use GTK2. Aborting.");
                    systemTrayMenu = null;
                    systemTray = null;
                    return;
                }
            }
        }
        if (DEBUG) {
            logger.debug("OS: {}", (Object)System.getProperty("os.name"));
            logger.debug("Arch: {}", (Object)System.getProperty("os.arch"));
            String jvmName = System.getProperty("java.vm.name", "");
            String jvmVersion = System.getProperty("java.version", "");
            String jvmVendor = System.getProperty("java.vm.specification.vendor", "");
            logger.debug("{} {} {}", new Object[]{jvmVendor, jvmName, jvmVersion});
            logger.debug("Is Auto sizing tray/menu? {}", (Object)AUTO_SIZE);
            logger.debug("Is JavaFX detected? {}", (Object)JavaFX.isLoaded);
            logger.debug("Is SWT detected? {}", (Object)Swt.isLoaded);
            if (Swt.isLoaded) {
                logger.debug("SWT version: {}", (Object)Swt.getVersion());
            }
            logger.debug("Java Swing L&F: {}", (Object)UIManager.getLookAndFeel().getID());
            if (FORCE_TRAY_TYPE == TrayType.AutoDetect) {
                logger.debug("Auto-detecting tray type");
            } else {
                logger.debug("Forced tray type: {}", (Object)FORCE_TRAY_TYPE.name());
            }
            if (OS.isLinux()) {
                logger.debug("Force GTK2: {}", (Object)FORCE_GTK2);
                logger.debug("Prefer GTK3: {}", (Object)PREFER_GTK3);
            }
        }
        if ((trayType = FORCE_TRAY_TYPE == TrayType.AutoDetect ? SystemTray.getAutoDetectTrayType() : SystemTray.selectTypeQuietly(FORCE_TRAY_TYPE)) == null) {
            if (OSUtil.DesktopEnv.isChromeOS()) {
                logger.error("ChromeOS detected and it is not supported. Aborting.");
            }
            systemTrayMenu = null;
            systemTray = null;
            return;
        }
        if (isNix) {
            if (SystemTray.isTrayType(trayType, TrayType.GtkStatusIcon)) {
                OSUtil.DesktopEnv.Env de = OSUtil.DesktopEnv.get();
                if (OSUtil.Linux.isUbuntu() && OSUtil.DesktopEnv.isUnity(de)) {
                    if (AUTO_FIX_INCONSISTENCIES) {
                        if (Gtk.isGtk2) {
                            trayType = SystemTray.selectTypeQuietly(TrayType.Swing);
                            logger.warn("Forcing Swing Tray type because Ubuntu Unity display environment removed support for GtkStatusIcons and GTK2+ was specified.");
                        } else {
                            FORCE_TRAY_TYPE = TrayType.AppIndicator;
                            trayType = SystemTray.selectTypeQuietly(TrayType.AppIndicator);
                            logger.warn("Forcing AppIndicator because Ubuntu Unity display environment removed support for GtkStatusIcons.");
                        }
                    } else {
                        logger.error("Unable to use the GtkStatusIcons when running on Ubuntu with the Unity display environment, and thus the SystemTray will not work. Please set `SystemTray.AUTO_FIX_INCONSISTENCIES=true;` to automatically fix this problem.");
                        systemTrayMenu = null;
                        systemTray = null;
                        return;
                    }
                }
                if (de == OSUtil.DesktopEnv.Env.Gnome) {
                    boolean hasWeirdOsProblems;
                    boolean bl = hasWeirdOsProblems = OSUtil.Linux.isKali() || OSUtil.Linux.isFedora();
                    if (hasWeirdOsProblems) {
                        PREFER_GTK3 = false;
                        if (DEBUG) {
                            logger.debug("Preferring GTK2 because this OS has weird graphical issues with GTK3 status icons");
                        }
                    }
                }
            }
            if (SystemTray.isTrayType(trayType, TrayType.AppIndicator)) {
                if (ENABLE_ROOT_CHECK && OSUtil.Linux.isRoot()) {
                    if (AUTO_FIX_INCONSISTENCIES) {
                        trayType = SystemTray.selectTypeQuietly(TrayType.Swing);
                        logger.warn("Attempting to load the SystemTray as the 'root/sudo' user. This will likely not work because of dbus restrictions. Using the Swing Tray type instead. Please refer to the readme notes or issue #63 on how to work around this.");
                    } else {
                        logger.error("Attempting to load the SystemTray as the 'root/sudo' user. This will likely NOT WORK because of dbus restrictions. Please refer to the readme notes or issue #63 on how to work around this.");
                    }
                }
                if (OSUtil.Linux.isElementaryOS() && OSUtil.Linux.getElementaryOSVersion()[0] >= 5 && !new File("/usr/share/doc/wingpanel-indicator-ayatana").isDirectory()) {
                    logger.error("Unable to use the SystemTray as-is with this version of ElementaryOS. By default, tray icons *are not* supported, but a workaround has been developed. Please see: https://git.dorkbox.com/dorkbox/elementary-indicators");
                    systemTrayMenu = null;
                    systemTray = null;
                    return;
                }
            }
        }
        if (trayType == null) {
            trayType = SystemTray.selectTypeQuietly(TrayType.Swing);
            logger.error("SystemTray initialization failed. (Unable to discover which implementation to use). Falling back to the Swing Tray.");
        }
        final AtomicReference<Tray> reference = new AtomicReference<Tray>();
        CacheUtil.tempDir = "SystemTrayImages";
        try {
            if (isNix) {
                GtkEventDispatch.startGui(FORCE_GTK2, PREFER_GTK3, DEBUG);
                GtkEventDispatch.waitForEventsToComplete();
                if (DEBUG) {
                    logger.debug("GTK Version: " + Gtk.MAJOR + "." + Gtk.MINOR + "." + Gtk.MICRO);
                    logger.debug("Is the system already running GTK? {}", (Object)Gtk.alreadyRunningGTK);
                }
                if (!Gtk.isLoaded) {
                    trayType = SystemTray.selectTypeQuietly(TrayType.Swing);
                    logger.error("Unable to initialize GTK! Something is severely wrong! Using the Swing Tray type instead.");
                } else if (SystemTray.isTrayType(trayType, TrayType.AppIndicator) && !AppIndicator.isLoaded) {
                    if (AUTO_FIX_INCONSISTENCIES && java.awt.SystemTray.isSupported() && !OSUtil.DesktopEnv.isKDE()) {
                        trayType = SystemTray.selectTypeQuietly(TrayType.Swing);
                        logger.warn("Unable to initialize the AppIndicator correctly. Using the Swing Tray type instead.");
                        logger.warn(AppIndicator.getInstallString(GtkCheck.isGtk2));
                    } else {
                        logger.error("AppIndicator unable to load.  " + AppIndicator.getInstallString(GtkCheck.isGtk2));
                        systemTrayMenu = null;
                        systemTray = null;
                        return;
                    }
                }
            }
            if (AUTO_FIX_INCONSISTENCIES && SWING_UI == null) {
                if (isNix && SystemTray.isTrayType(trayType, TrayType.Swing)) {
                    SWING_UI = new LinuxSwingUI();
                } else if (isWindows && (SystemTray.isTrayType(trayType, TrayType.Swing) || SystemTray.isTrayType(trayType, TrayType.WindowsNotifyIcon))) {
                    SWING_UI = new WindowsSwingUI();
                }
            }
            int trayImageSize = SizeAndScalingUtil.getTrayImageSize();
            int menuImageSize = SizeAndScalingUtil.getMenuImageSize(trayType);
            if (DEBUG) {
                logger.debug("Tray indicator image size: {}", (Object)trayImageSize);
                logger.debug("Tray menu image size: {}", (Object)menuImageSize);
            }
            if (AUTO_FIX_INCONSISTENCIES) {
                if (isWindows && SystemTray.isTrayType(trayType, TrayType.Swing)) {
                    SystemTrayFixes.fixWindows(trayImageSize);
                } else if (isMacOsX && (SystemTray.isTrayType(trayType, TrayType.AWT) || SystemTray.isTrayType(trayType, TrayType.Swing))) {
                    SystemTrayFixes.fixMacOS();
                } else if (isNix && SystemTray.isTrayType(trayType, TrayType.Swing)) {
                    SystemTrayFixes.fixLinux(trayImageSize);
                }
            }
            if ((JavaFX.isLoaded || Swt.isLoaded) && SwingUtilities.isEventDispatchThread()) {
                logger.error("SystemTray initialization for JavaFX or SWT **CAN NOT** occur on the Swing Event Dispatch Thread (EDT). Something is seriously wrong.");
                systemTrayMenu = null;
                systemTray = null;
                return;
            }
            if (SystemTray.isTrayType(trayType, TrayType.Swing) || SystemTray.isTrayType(trayType, TrayType.AWT) || SystemTray.isTrayType(trayType, TrayType.WindowsNotifyIcon)) {
                Toolkit.getDefaultToolkit();
            }
            systemTray = new SystemTray();
            if (JavaFX.isLoaded || Swt.isLoaded || isNix && (SystemTray.isTrayType(trayType, TrayType.GtkStatusIcon) || SystemTray.isTrayType(trayType, TrayType.AppIndicator)) || SystemTray.isTrayType(trayType, TrayType.WindowsNotifyIcon)) {
                try {
                    reference.set((Tray)trayType.getConstructors()[0].newInstance(systemTray));
                }
                catch (Exception e) {
                    logger.error("Unable to create tray type: '" + trayType.getSimpleName() + "'", (Throwable)e);
                }
            } else if (SystemTray.isTrayType(trayType, TrayType.Swing) || SystemTray.isTrayType(trayType, TrayType.AWT)) {
                final Class<? extends Tray> finalTrayType = trayType;
                SwingUtil.invokeAndWait(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            reference.set((Tray)finalTrayType.getConstructors()[0].newInstance(systemTray));
                        }
                        catch (Exception e) {
                            logger.error("Unable to create tray type: '" + finalTrayType.getSimpleName() + "'", (Throwable)e);
                        }
                    }
                });
            } else {
                logger.error("Unable to create tray type: '{}'. Aborting!", (Object)trayType.getSimpleName());
            }
        }
        catch (Exception e) {
            logger.error("Unable to create tray type: '{}'", (Object)trayType.getSimpleName(), (Object)e);
        }
        systemTrayMenu = (Tray)reference.get();
        if (systemTrayMenu != null) {
            if (DEBUG) {
                logger.info("Successfully loaded type: {}", (Object)trayType.getSimpleName());
            } else {
                logger.info("Successfully loaded");
            }
        }
        if (ENABLE_SHUTDOWN_HOOK) {
            if (JavaFX.isLoaded) {
                JavaFX.onShutdown(new Runnable(){

                    @Override
                    public void run() {
                        if (systemTray != null) {
                            systemTray.shutdown();
                        }
                    }
                });
            } else if (Swt.isLoaded) {
                Swt.onShutdown(new Runnable(){

                    @Override
                    public void run() {
                        if (systemTray != null) {
                            systemTray.shutdown();
                        }
                    }
                });
            } else if (SystemTray.isTrayType(trayType, TrayType.Swing) || SystemTray.isTrayType(trayType, TrayType.WindowsNotifyIcon)) {
                Runtime.getRuntime().addShutdownHook(new Thread(new Runnable(){

                    @Override
                    public void run() {
                        if (systemTray != null) {
                            systemTray.shutdown();
                        }
                    }
                }));
            }
        }
    }

    public static String getVersion() {
        return "3.17";
    }

    public static SystemTray get() {
        SystemTray.init();
        return systemTray;
    }

    public void shutdown() {
        Tray menu = systemTrayMenu;
        if (menu != null) {
            menu.remove();
        }
        systemTrayMenu = null;
        EventDispatch.shutdown();
    }

    public String getStatus() {
        Tray tray = systemTrayMenu;
        if (tray != null) {
            return tray.getStatus();
        }
        return "";
    }

    public void setStatus(String statusText) {
        Tray tray = systemTrayMenu;
        if (tray != null) {
            tray.setStatus(statusText);
        }
    }

    public Menu getMenu() {
        return systemTrayMenu;
    }

    public Menu setMenu(JMenu jMenu) {
        Tray menu = systemTrayMenu;
        if (menu != null) {
            Component[] menuComponents;
            Icon icon = jMenu.getIcon();
            BufferedImage bimage = new BufferedImage(icon.getIconWidth(), icon.getIconHeight(), 2);
            this.setImage(bimage);
            for (Component c : menuComponents = jMenu.getMenuComponents()) {
                if (c instanceof JMenu) {
                    menu.add((JMenu)c);
                    continue;
                }
                if (c instanceof JCheckBoxMenuItem) {
                    menu.add((JCheckBoxMenuItem)c);
                    continue;
                }
                if (c instanceof JMenuItem) {
                    menu.add((JMenuItem)c);
                    continue;
                }
                if (!(c instanceof JSeparator)) continue;
                menu.add((JSeparator)c);
            }
        }
        return menu;
    }

    public void setEnabled(boolean enabled) {
        Tray menu = systemTrayMenu;
        if (menu != null) {
            menu.setEnabled(enabled);
        }
    }

    public void setTooltip(String tooltipText) {
        Tray tray = systemTrayMenu;
        if (tray != null) {
            tray.setTooltip(tooltipText);
        }
    }

    public void setImage(File imageFile) {
        if (imageFile == null) {
            throw new NullPointerException("imageFile");
        }
        Tray menu = systemTrayMenu;
        if (menu != null) {
            menu.setImage_(ImageResizeUtil.shouldResizeOrCache(true, imageFile));
        }
    }

    public void setImage(String imagePath) {
        if (imagePath == null) {
            throw new NullPointerException("imagePath");
        }
        Tray tray = systemTrayMenu;
        if (tray != null) {
            tray.setImage_(ImageResizeUtil.shouldResizeOrCache(true, imagePath));
        }
    }

    public void setImage(URL imageUrl) {
        if (imageUrl == null) {
            throw new NullPointerException("imageUrl");
        }
        Tray menu = systemTrayMenu;
        if (menu != null) {
            menu.setImage_(ImageResizeUtil.shouldResizeOrCache(true, imageUrl));
        }
    }

    public void setImage(InputStream imageStream) {
        if (imageStream == null) {
            throw new NullPointerException("imageStream");
        }
        Tray menu = systemTrayMenu;
        if (menu != null) {
            menu.setImage_(ImageResizeUtil.shouldResizeOrCache(true, imageStream));
        }
    }

    public void setImage(Image image) {
        if (image == null) {
            throw new NullPointerException("image");
        }
        Tray menu = systemTrayMenu;
        if (menu != null) {
            menu.setImage_(ImageResizeUtil.shouldResizeOrCache(true, image));
        }
    }

    public void setImage(ImageInputStream imageStream) {
        if (imageStream == null) {
            throw new NullPointerException("image");
        }
        Tray tray = systemTrayMenu;
        if (tray != null) {
            tray.setImage_(ImageResizeUtil.shouldResizeOrCache(true, imageStream));
        }
    }

    public int getTrayImageSize() {
        return SizeAndScalingUtil.getTrayImageSize();
    }

    public int getMenuImageSize() {
        return SizeAndScalingUtil.getMenuImageSize(systemTrayMenu.getClass());
    }

    public static enum TrayType {
        AutoDetect,
        GtkStatusIcon,
        AppIndicator,
        WindowsNotifyIcon,
        Swing,
        AWT;

    }
}

