/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jcp.xml.dsig.internal.dom;

import java.security.Provider;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.xml.crypto.MarshalException;
import javax.xml.crypto.XMLCryptoContext;
import javax.xml.crypto.dsig.Manifest;
import javax.xml.crypto.dsig.Reference;
import org.apache.jcp.xml.dsig.internal.dom.BaseStructure;
import org.apache.jcp.xml.dsig.internal.dom.DOMReference;
import org.apache.jcp.xml.dsig.internal.dom.DOMUtils;
import org.apache.jcp.xml.dsig.internal.dom.Utils;
import org.apache.jcp.xml.dsig.internal.dom.XmlWriter;
import org.w3c.dom.Element;

public final class DOMManifest
extends BaseStructure
implements Manifest {
    private final List<DOMReference> references;
    private final String id;

    public DOMManifest(List<DOMReference> references, String id) {
        if (references == null) {
            throw new NullPointerException("references cannot be null");
        }
        this.references = Collections.unmodifiableList(new ArrayList<DOMReference>(references));
        if (this.references.isEmpty()) {
            throw new IllegalArgumentException("list of references must contain at least one entry");
        }
        int size = this.references.size();
        for (int i = 0; i < size; ++i) {
            if (this.references.get(i) instanceof Reference) continue;
            throw new ClassCastException("references[" + i + "] is not a valid type");
        }
        this.id = id;
    }

    public DOMManifest(Element manElem, XMLCryptoContext context, Provider provider) throws MarshalException {
        this.id = DOMUtils.getIdAttributeValue(manElem, "Id");
        boolean secVal = Utils.secureValidation(context);
        Element refElem = DOMUtils.getFirstChildElement(manElem, "Reference");
        ArrayList<DOMReference> refs = new ArrayList<DOMReference>();
        refs.add(new DOMReference(refElem, context, provider));
        refElem = DOMUtils.getNextSiblingElement(refElem);
        while (refElem != null) {
            String localName = refElem.getLocalName();
            if (!localName.equals("Reference")) {
                throw new MarshalException("Invalid element name: " + localName + ", expected Reference");
            }
            refs.add(new DOMReference(refElem, context, provider));
            if (secVal && refs.size() > 30) {
                String error = "A maxiumum of 30 references per Manifest are allowed with secure validation";
                throw new MarshalException(error);
            }
            refElem = DOMUtils.getNextSiblingElement(refElem);
        }
        this.references = Collections.unmodifiableList(refs);
    }

    @Override
    public String getId() {
        return this.id;
    }

    public static List<Reference> getManifestReferences(Manifest mf) {
        return mf.getReferences();
    }

    public List<DOMReference> getReferences() {
        return this.references;
    }

    public static void marshal(XmlWriter xwriter, Manifest manif, String dsPrefix, XMLCryptoContext context) throws MarshalException {
        xwriter.writeStartElement(dsPrefix, "Manifest", "http://www.w3.org/2000/09/xmldsig#");
        xwriter.writeIdAttribute("", "", "Id", manif.getId());
        List<Reference> references = manif.getReferences();
        for (Reference ref : references) {
            ((DOMReference)ref).marshal(xwriter, dsPrefix, context);
        }
        xwriter.writeEndElement();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Manifest)) {
            return false;
        }
        Manifest oman = (Manifest)o;
        boolean idsEqual = this.id == null ? oman.getId() == null : this.id.equals(oman.getId());
        return idsEqual && this.references.equals(oman.getReferences());
    }

    public int hashCode() {
        int result = 17;
        if (this.id != null) {
            result = 31 * result + this.id.hashCode();
        }
        result = 31 * result + this.references.hashCode();
        return result;
    }
}

