/*
 * Decompiled with CFR 0.152.
 */
package org.universis.signer;

import com.itextpdf.text.Rectangle;
import fi.iki.elonen.NanoHTTPD;
import fi.iki.elonen.router.RouterNanoHTTPD;
import java.io.File;
import java.io.IOException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.crypto.BadPaddingException;
import javax.security.auth.login.FailedLoginException;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.universis.signer.BadRequestHandler;
import org.universis.signer.CorsHandler;
import org.universis.signer.FileStreamHandler;
import org.universis.signer.ForbiddenHandler;
import org.universis.signer.MethodNotAllowedHandler;
import org.universis.signer.NotFoundHandler;
import org.universis.signer.ServerErrorHandler;
import org.universis.signer.Signer;
import org.universis.signer.SignerAppConfiguration;
import org.universis.signer.UnauthorizedHandler;

public class SignerHandler
implements RouterNanoHTTPD.UriResponder {
    private static final Logger log = LogManager.getLogger(SignerHandler.class);
    public HashMap<String, String> files = null;

    public SignerHandler() {
    }

    public SignerHandler(HashMap<String, String> files) {
        this.files = files;
    }

    public NanoHTTPD.Response get(RouterNanoHTTPD.UriResource uriResource, Map<String, String> map, NanoHTTPD.IHTTPSession ihttpSession) {
        return new MethodNotAllowedHandler().get(uriResource, map, ihttpSession);
    }

    public NanoHTTPD.Response put(RouterNanoHTTPD.UriResource uriResource, Map<String, String> map, NanoHTTPD.IHTTPSession ihttpSession) {
        return new MethodNotAllowedHandler().get(uriResource, map, ihttpSession);
    }

    public NanoHTTPD.Response post(RouterNanoHTTPD.UriResource uriResource, Map<String, String> map, NanoHTTPD.IHTTPSession ihttpSession) {
        String authorizationHeader = (String)ihttpSession.getHeaders().get("authorization");
        if (authorizationHeader == null || !authorizationHeader.startsWith("Basic ")) {
            return new ForbiddenHandler().get(uriResource, map, ihttpSession);
        }
        byte[] decodedBytes = Base64.decodeBase64((String)authorizationHeader.replaceFirst("Basic ", ""));
        String[] usernamePassword = new String(decodedBytes).split(":");
        KeyStore ks = null;
        SignerAppConfiguration configuration = null;
        try {
            Map params;
            if (this.files == null) {
                this.files = new HashMap();
                ihttpSession.parseBody(this.files);
                for (String string : this.files.values()) {
                }
            }
            if (!(params = ihttpSession.getParameters()).containsKey("thumbprint")) {
                return new BadRequestHandler("Parameter thumbprint may not be null.").get(uriResource, map, ihttpSession);
            }
            String thumbprint = (String)((List)params.get("thumbprint")).get(0);
            String file = null;
            for (String key : this.files.keySet()) {
                if (!key.startsWith("file")) continue;
                file = this.files.get(key);
                break;
            }
            if (file == null) {
                return new BadRequestHandler("Parameter file may not be null.").get(uriResource, map, ihttpSession);
            }
            String outFile = File.createTempFile("signed", ".pdf").getAbsolutePath();
            configuration = (SignerAppConfiguration)uriResource.initParameter(SignerAppConfiguration.class);
            if (configuration == null) {
                return new ServerErrorHandler("Application configuration cannot be empty at this context").get(uriResource, map, ihttpSession);
            }
            if (configuration.keyStore == null) {
                return new ServerErrorHandler("Invalid application configuration. Keystore cannot be empty at this context").get(uriResource, map, ihttpSession);
            }
            Rectangle position = null;
            if (params.containsKey("position")) {
                String requestPosition = (String)((List)params.get("position")).get(0);
                String[] dimensions = requestPosition.split(",");
                if (dimensions.length != 4) {
                    return new BadRequestHandler("Invalid signature position format.").get(uriResource, map, ihttpSession);
                }
                for (int i = 0; i < dimensions.length; ++i) {
                    dimensions[i] = dimensions[i].trim();
                }
                position = new Rectangle(Integer.parseInt(dimensions[0]), Integer.parseInt(dimensions[1]), Integer.parseInt(dimensions[2]), Integer.parseInt(dimensions[3]));
            }
            String reason = null;
            if (params.containsKey("reason")) {
                reason = (String)((List)params.get("reason")).get(0);
            }
            String name = "sig";
            if (params.containsKey("name")) {
                name = (String)((List)params.get("name")).get(0);
            }
            String timestampServer = null;
            if (params.containsKey("timestampServer")) {
                timestampServer = (String)((List)params.get("timestampServer")).get(0);
            }
            int page = 1;
            if (params.containsKey("page")) {
                page = Integer.parseInt((String)((List)params.get("page")).get(0));
            }
            try {
                ks = configuration.getKeyStore(usernamePassword[1]);
            }
            catch (KeyStoreException e) {
                log.error(ExceptionUtils.getStackTrace((Throwable)e));
                Throwable cause = e.getCause();
                if (cause instanceof NoSuchAlgorithmException) {
                    return new NotFoundHandler(e).get(uriResource, map, ihttpSession);
                }
                return new ServerErrorHandler(e).get(uriResource, map, ihttpSession);
            }
            catch (IOException e) {
                log.error(ExceptionUtils.getStackTrace((Throwable)e));
                Throwable cause = e.getCause();
                if (cause instanceof BadPaddingException || cause instanceof FailedLoginException || cause instanceof UnrecoverableKeyException) {
                    return new UnauthorizedHandler(e).get(uriResource, map, ihttpSession);
                }
                return new ServerErrorHandler(e).get(uriResource, map, ihttpSession);
            }
            String imageFile = null;
            for (String key : this.files.keySet()) {
                if (!key.startsWith("image")) continue;
                imageFile = this.files.get(key);
                break;
            }
            Signer signer = new Signer(ks);
            signer.sign(file, outFile, thumbprint, usernamePassword[1], reason, page, position, timestampServer, name, imageFile);
            File f = new File(outFile);
            if (!f.exists()) {
                configuration.tryCloseKeyStore(ks);
                return new NotFoundHandler().get(uriResource, map, ihttpSession);
            }
            String contentDisposition = "attachment; filename=\"" + f.getName() + "\"";
            NanoHTTPD.Response res = new FileStreamHandler(outFile, "application/pdf").get(uriResource, map, ihttpSession);
            res.addHeader("Content-Disposition", contentDisposition);
            CorsHandler.enable(res);
            Map headers = ihttpSession.getHeaders();
            if (headers.containsKey("origin")) {
                res.addHeader("Access-Control-Allow-Origin", (String)headers.get("origin"));
            }
            configuration.tryCloseKeyStore(ks);
            return res;
        }
        catch (Exception e) {
            log.error(ExceptionUtils.getStackTrace((Throwable)e));
            if (configuration != null && ks != null) {
                try {
                    configuration.tryCloseKeyStore(ks);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
            return new ServerErrorHandler(e).get(uriResource, map, ihttpSession);
        }
    }

    public NanoHTTPD.Response delete(RouterNanoHTTPD.UriResource uriResource, Map<String, String> map, NanoHTTPD.IHTTPSession ihttpSession) {
        return new MethodNotAllowedHandler().get(uriResource, map, ihttpSession);
    }

    public NanoHTTPD.Response other(String s, RouterNanoHTTPD.UriResource uriResource, Map<String, String> map, NanoHTTPD.IHTTPSession ihttpSession) {
        return new CorsHandler().other(s, uriResource, map, ihttpSession);
    }
}

