/*
 * Decompiled with CFR 0.152.
 */
package org.universis.signer;

import com.fasterxml.jackson.dataformat.xml.XmlMapper;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.InvalidParameterException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.Provider;
import java.security.ProviderException;
import java.security.Security;
import java.security.cert.CertificateException;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.universis.signer.SignerRouteConfiguration;
import org.universis.signer.SlotInfo;
import sun.security.pkcs11.SunPKCS11;
import sun.security.pkcs11.wrapper.CK_SLOT_INFO;
import sun.security.pkcs11.wrapper.PKCS11;
import sun.security.pkcs11.wrapper.PKCS11Constants;
import sun.security.pkcs11.wrapper.PKCS11Exception;

public class SignerAppConfiguration {
    private static final Logger log = LogManager.getLogger(SignerAppConfiguration.class);
    public String storeType = "pkcs12";
    public String providerArg;
    public String keyStore;
    public String keyStorePass;
    public SignerRouteConfiguration routeConfiguration = new SignerRouteConfiguration();
    public boolean daemon;
    public int port = 2465;
    public String host = "127.0.0.1";

    public KeyStore getKeyStore(String password) throws KeyStoreException, IOException, CertificateException, NoSuchAlgorithmException, PKCS11Exception, NoSuchFieldException, IllegalAccessException {
        if (this.storeType.toLowerCase().equals("pkcs12")) {
            KeyStore ks = KeyStore.getInstance(this.storeType);
            ks.load(new FileInputStream(this.keyStore), password.toCharArray());
            return ks;
        }
        if (this.storeType.toLowerCase().equals("pkcs11")) {
            SlotInfo[] slots = this.getSlots(true);
            if (slots.length == 0) {
                throw new IOException("No slot with a token was found");
            }
            SunPKCS11 p = new SunPKCS11(this.providerArg);
            if (Security.getProvider(p.getName()) == null) {
                Security.addProvider(p);
            }
            KeyStore ks = KeyStore.getInstance(this.storeType, p);
            ks.load(null, password.toCharArray());
            return ks;
        }
        throw new InvalidParameterException("The specified key store type has not implemented yet.");
    }

    public void tryCloseKeyStore(KeyStore ks) {
        if (ks == null) {
            return;
        }
        try {
            Provider provider = ks.getProvider();
            if (provider == null) {
                return;
            }
            if (this.storeType.toLowerCase().equals("pkcs11")) {
                this.closeKeyStore(ks);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void finalizeProvider(PKCS11 pkcs11) throws IOException {
        try {
            Field f = PKCS11.class.getDeclaredField("moduleMap");
            f.setAccessible(true);
            Map moduleMap = (Map)f.get(pkcs11);
            moduleMap.clear();
            pkcs11.C_Finalize(PKCS11Constants.NULL_PTR);
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchFieldException | SecurityException | PKCS11Exception e) {
            throw new IOException("PKCS11 close failed", e);
        }
    }

    private void closeKeyStore(KeyStore ks) throws Exception {
        Provider provider = ks.getProvider();
        if (provider == null) {
            return;
        }
        try {
            Field f = SunPKCS11.class.getDeclaredField("p11");
            f.setAccessible(true);
            PKCS11 objectPKCS11 = (PKCS11)f.get(provider);
            this.finalizeProvider(objectPKCS11);
        }
        catch (Exception e) {
            log.error(ExceptionUtils.getStackTrace((Throwable)e));
        }
        provider.clear();
        ((SunPKCS11)provider).setCallbackHandler(null);
        Security.removeProvider(provider.getName());
        provider = null;
        ks = null;
        System.gc();
    }

    private boolean trySetSlot(int newSlot, boolean forceSet) throws IOException {
        assert (this.providerArg != null);
        Properties properties = new Properties();
        properties.load(Files.newInputStream(Paths.get(this.providerArg, new String[0]), new OpenOption[0]));
        String slot = (String)properties.get("slot");
        if (slot == null || forceSet) {
            String tempDir = System.getProperty("java.io.tmpdir");
            Path tempFile = Paths.get(tempDir, "org.universis.signer.eToken.cfg");
            properties.setProperty("slot", String.valueOf(newSlot));
            properties.store(Files.newOutputStream(tempFile.toAbsolutePath(), new OpenOption[0]), null);
            this.providerArg = tempFile.toAbsolutePath().toString();
            System.out.println("PKCS11 provider runtime arguments have been successfully saved at " + this.providerArg);
            return true;
        }
        return false;
    }

    public SlotInfo[] getSlots(boolean availableOnly) throws PKCS11Exception, NoSuchFieldException, IllegalAccessException, IOException {
        if (this.storeType.toLowerCase().equals("pkcs12")) {
            return new SlotInfo[0];
        }
        if (this.storeType.toLowerCase().equals("pkcs11")) {
            int newSlot = 0;
            int maxSlots = 16;
            boolean isSet = this.trySetSlot(newSlot, false);
            if (!isSet) {
                newSlot = maxSlots - 1;
            }
            while (newSlot < maxSlots) {
                try {
                    SunPKCS11 p = new SunPKCS11(this.providerArg);
                    Field f = SunPKCS11.class.getDeclaredField("p11");
                    f.setAccessible(true);
                    PKCS11 objectPKCS11 = (PKCS11)f.get(p);
                    long[] slots = objectPKCS11.C_GetSlotList(availableOnly);
                    SlotInfo[] res = new SlotInfo[slots.length];
                    for (int i = 0; i < slots.length; ++i) {
                        final long slotNumber = slots[i];
                        final CK_SLOT_INFO info = objectPKCS11.C_GetSlotInfo(slotNumber);
                        res[i] = new SlotInfo(){
                            {
                                this.slot = slotNumber;
                                this.slotDescription = new String(info.slotDescription).trim();
                                this.manufacturerID = new String(info.manufacturerID).trim();
                                this.flags = info.flags;
                                this.hardwareVersion = info.hardwareVersion.toString();
                                this.firmwareVersion = info.firmwareVersion.toString();
                            }
                        };
                    }
                    return res;
                }
                catch (Exception ex) {
                    if (ex instanceof ProviderException) {
                        if (!Objects.equals(ex.getCause().getMessage(), "CKR_SLOT_ID_INVALID")) {
                            throw ex;
                        }
                        this.trySetSlot(++newSlot, true);
                        continue;
                    }
                    throw ex;
                }
            }
            if (newSlot == maxSlots) {
                throw new ProviderException("Initialization failed. Invalid slot id.");
            }
        }
        return new SlotInfo[0];
    }

    void loadRoutesFromFile(String inputFile) throws IOException {
        File routes = new File(inputFile);
        if (routes.exists()) {
            XmlMapper xmlMapper = new XmlMapper();
            FileInputStream in = new FileInputStream(routes);
            this.routeConfiguration = (SignerRouteConfiguration)xmlMapper.readValue((InputStream)in, SignerRouteConfiguration.class);
        }
    }
}

