/*
 * Decompiled with CFR 0.152.
 */
package org.universis.signer;

import fi.iki.elonen.NanoHTTPD;
import fi.iki.elonen.router.RouterNanoHTTPD;
import java.io.IOException;
import java.net.MalformedURLException;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.universis.signer.DocumentSignerHandler;
import org.universis.signer.EmbedHandler;
import org.universis.signer.InspectSignatureBlockHandler;
import org.universis.signer.KeyStoreHandler;
import org.universis.signer.OpenapiHandler;
import org.universis.signer.RootHandler;
import org.universis.signer.SignerAppConfiguration;
import org.universis.signer.SignerRoute;
import org.universis.signer.SlotHandler;
import org.universis.signer.VerifyHandler;

public class SignerApp
extends RouterNanoHTTPD {
    private static final Logger log = LogManager.getLogger(SignerApp.class);
    private static final String DEFAULT_HOST = "localhost";
    private static final int DEFAULT_PORT = 2465;
    protected SignerAppConfiguration configuration;

    public SignerApp() throws IOException {
        super(DEFAULT_HOST, 2465);
        this.addMappings();
    }

    public SignerApp(SignerAppConfiguration configuration) throws IOException {
        super(configuration.host, configuration.port);
        this.configuration = configuration;
        this.addMappings();
    }

    public void start() throws IOException {
        log.debug("starting({}, {})", (Object)5000, (Object)this.configuration.daemon);
        this.start(5000, this.configuration.daemon);
        log.debug("started({}, {})", (Object)5000, (Object)this.configuration.daemon);
    }

    public void addMappings() {
        NanoHTTPD.mimeTypes().put("json", "application/json");
        super.addMappings();
        if (this.configuration.routeConfiguration != null) {
            log.debug("Enumerating routes");
            if (this.configuration.routeConfiguration.routes.size() == 0) {
                log.info("Configurable routes are empty. Continue.");
            }
            this.configuration.routeConfiguration.routes.forEach(signerRoute -> {
                try {
                    if (signerRoute.plugin != null) {
                        log.debug("addRoute({},{},{})", (Object)signerRoute.plugin, (Object)signerRoute.path, (Object)signerRoute.className);
                        this.addRoute(signerRoute.path, SignerRoute.loadClass(signerRoute.plugin, signerRoute.className), new Object[]{this.configuration});
                    } else {
                        log.debug("addRoute({},{})", (Object)signerRoute.path, (Object)signerRoute.className);
                        this.addRoute(signerRoute.path, Class.forName(signerRoute.className), new Object[]{this.configuration});
                    }
                }
                catch (ClassNotFoundException | MalformedURLException e) {
                    log.error("addRoute({},{})", (Object)signerRoute.path, (Object)signerRoute.className);
                    log.error(ExceptionUtils.getStackTrace((Throwable)e));
                }
            });
        } else {
            log.info("Configurable routes are undefined. Continue.");
        }
        this.addRoute("/", RootHandler.class, new Object[0]);
        this.addRoute("/index.html", RootHandler.class, new Object[0]);
        this.addRoute("/openapi/schema.json", OpenapiHandler.class, new Object[0]);
        this.addRoute("/keystore/certs", KeyStoreHandler.class, new Object[]{this.configuration});
        this.addRoute("/signature/inspect", InspectSignatureBlockHandler.class, new Object[]{this.configuration});
        this.addRoute("/signature/embed", EmbedHandler.class, new Object[]{this.configuration});
        this.addRoute("/sign/", DocumentSignerHandler.class, new Object[]{this.configuration});
        this.addRoute("/verify/", VerifyHandler.class, new Object[]{this.configuration});
        this.addRoute("/slots/", SlotHandler.class, new Object[]{this.configuration});
    }
}

