/*
 * Decompiled with CFR 0.152.
 */
package org.universis.signer;

import fi.iki.elonen.NanoHTTPD;
import fi.iki.elonen.router.RouterNanoHTTPD;
import java.io.File;
import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.universis.signer.BadRequestHandler;
import org.universis.signer.CorsHandler;
import org.universis.signer.JsonResponseHandler;
import org.universis.signer.MethodNotAllowedHandler;
import org.universis.signer.ServerErrorHandler;
import org.universis.signer.Signer;
import org.universis.signer.SignerHandler;
import org.universis.signer.VerifySignatureResult;

public class PdfVerifyHandler
implements RouterNanoHTTPD.UriResponder {
    private static final Logger log = LogManager.getLogger(SignerHandler.class);
    public HashMap<String, String> files = null;

    public PdfVerifyHandler() {
    }

    public PdfVerifyHandler(HashMap<String, String> files) {
        this.files = files;
    }

    public NanoHTTPD.Response get(RouterNanoHTTPD.UriResource uriResource, Map<String, String> map, NanoHTTPD.IHTTPSession ihttpSession) {
        return new MethodNotAllowedHandler().get(uriResource, map, ihttpSession);
    }

    public NanoHTTPD.Response put(RouterNanoHTTPD.UriResource uriResource, Map<String, String> map, NanoHTTPD.IHTTPSession ihttpSession) {
        return new MethodNotAllowedHandler().get(uriResource, map, ihttpSession);
    }

    public NanoHTTPD.Response post(RouterNanoHTTPD.UriResource uriResource, Map<String, String> map, NanoHTTPD.IHTTPSession ihttpSession) {
        try {
            if (this.files == null) {
                this.files = new HashMap();
                ihttpSession.parseBody(this.files);
            }
            String inFile = this.files.get("file");
            if (!this.files.containsKey("file")) {
                return new BadRequestHandler("File parameter is missing").get(uriResource, map, ihttpSession);
            }
            Signer signer = new Signer();
            List<VerifySignatureResult> result = signer.verify(new File(inFile));
            NanoHTTPD.Response res = new JsonResponseHandler((Serializable)result.toArray()).get(uriResource, map, ihttpSession);
            CorsHandler.enable(res);
            return res;
        }
        catch (Exception e) {
            log.error(ExceptionUtils.getStackTrace((Throwable)e));
            return new ServerErrorHandler(e).get(uriResource, map, ihttpSession);
        }
    }

    public NanoHTTPD.Response delete(RouterNanoHTTPD.UriResource uriResource, Map<String, String> map, NanoHTTPD.IHTTPSession ihttpSession) {
        return new MethodNotAllowedHandler().get(uriResource, map, ihttpSession);
    }

    public NanoHTTPD.Response other(String s, RouterNanoHTTPD.UriResource uriResource, Map<String, String> map, NanoHTTPD.IHTTPSession ihttpSession) {
        return new CorsHandler().other(s, uriResource, map, ihttpSession);
    }
}

