/*
 * Decompiled with CFR 0.152.
 */
package org.universis.signer;

import com.itextpdf.text.pdf.PdfDictionary;
import com.itextpdf.text.pdf.PdfName;
import com.itextpdf.text.pdf.PdfReader;
import com.itextpdf.text.pdf.parser.ContentByteUtils;
import com.itextpdf.text.pdf.parser.PdfContentStreamProcessor;
import fi.iki.elonen.NanoHTTPD;
import fi.iki.elonen.router.RouterNanoHTTPD;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.universis.signer.BadRequestHandler;
import org.universis.signer.CorsHandler;
import org.universis.signer.InspectSignatureBlockResult;
import org.universis.signer.JsonResponseHandler;
import org.universis.signer.MethodNotAllowedHandler;
import org.universis.signer.ServerErrorHandler;
import org.universis.signer.SignatureBlockConfiguration;
import org.universis.signer.SignaturePositionListener;

public class InspectSignatureBlockHandler
implements RouterNanoHTTPD.UriResponder {
    private static final Logger log = LogManager.getLogger(InspectSignatureBlockHandler.class);

    public NanoHTTPD.Response get(RouterNanoHTTPD.UriResource uriResource, Map<String, String> map, NanoHTTPD.IHTTPSession ihttpSession) {
        return new MethodNotAllowedHandler().get(uriResource, map, ihttpSession);
    }

    public NanoHTTPD.Response put(RouterNanoHTTPD.UriResource uriResource, Map<String, String> map, NanoHTTPD.IHTTPSession ihttpSession) {
        return new MethodNotAllowedHandler().get(uriResource, map, ihttpSession);
    }

    public NanoHTTPD.Response post(RouterNanoHTTPD.UriResource uriResource, Map<String, String> map, NanoHTTPD.IHTTPSession ihttpSession) {
        HashMap files = new HashMap();
        try {
            ihttpSession.parseBody(files);
            Map params = ihttpSession.getParameters();
            for (String string : files.values()) {
            }
            if (!files.containsKey("file")) {
                return new BadRequestHandler("Parameter file may not be null.").get(uriResource, map, ihttpSession);
            }
            String inFile = (String)files.get("file");
            SignatureBlockConfiguration blockConfiguration = new SignatureBlockConfiguration();
            if (params.containsKey("text")) {
                ((List)params.get("text")).forEach(value -> {
                    try {
                        blockConfiguration.signatureBlockText.add(URLDecoder.decode(value, "UTF-8"));
                    }
                    catch (UnsupportedEncodingException e) {
                        e.printStackTrace();
                    }
                });
            } else {
                blockConfiguration.signatureBlockText.add("(digital signature)");
            }
            if (params.containsKey("textPosition")) {
                blockConfiguration.signatureBlockTextPosition = (String)((List)params.get("textPosition")).get(0);
            }
            if (params.containsKey("width")) {
                blockConfiguration.signatureBlockWidth = Integer.parseInt((String)((List)params.get("width")).get(0));
            }
            if (params.containsKey("height")) {
                blockConfiguration.signatureBlockHeight = Integer.parseInt((String)((List)params.get("height")).get(0));
            }
            PdfReader reader = new PdfReader(inFile);
            SignaturePositionListener listener = new SignaturePositionListener();
            listener.configuration = blockConfiguration;
            PdfContentStreamProcessor processor = new PdfContentStreamProcessor(listener);
            int numberOfPages = reader.getNumberOfPages();
            InspectSignatureBlockResult result = new InspectSignatureBlockResult();
            for (int pageNum = 1; pageNum <= numberOfPages; ++pageNum) {
                PdfDictionary pageDic = reader.getPageN(pageNum);
                PdfDictionary resourcesDic = pageDic.getAsDict(PdfName.RESOURCES);
                processor.processContent(ContentByteUtils.getContentBytesForPage(reader, pageNum), resourcesDic);
                if (listener.position == null) continue;
                result.position = new int[]{(int)listener.position.getLeft(), (int)listener.position.getBottom(), (int)listener.position.getLeft() + (int)listener.position.getWidth(), (int)listener.position.getBottom() + (int)listener.position.getHeight()};
                result.page = pageNum;
                break;
            }
            NanoHTTPD.Response res = new JsonResponseHandler(result).get(uriResource, map, ihttpSession);
            CorsHandler.enable(res);
            Map headers = ihttpSession.getHeaders();
            if (headers.containsKey("origin")) {
                res.addHeader("Access-Control-Allow-Origin", (String)headers.get("origin"));
            }
            return res;
        }
        catch (Exception e) {
            log.error(ExceptionUtils.getStackTrace((Throwable)e));
            return new ServerErrorHandler(e).get(uriResource, map, ihttpSession);
        }
    }

    public NanoHTTPD.Response delete(RouterNanoHTTPD.UriResource uriResource, Map<String, String> map, NanoHTTPD.IHTTPSession ihttpSession) {
        return new MethodNotAllowedHandler().get(uriResource, map, ihttpSession);
    }

    public NanoHTTPD.Response other(String s, RouterNanoHTTPD.UriResource uriResource, Map<String, String> map, NanoHTTPD.IHTTPSession ihttpSession) {
        return new CorsHandler().other(s, uriResource, map, ihttpSession);
    }
}

