/*
 * Decompiled with CFR 0.152.
 */
package org.universis.signer;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import fi.iki.elonen.NanoHTTPD;
import fi.iki.elonen.router.RouterNanoHTTPD;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.universis.signer.CorsHandler;

public class ErrorHandler
implements RouterNanoHTTPD.UriResponder {
    private static final Logger log = LogManager.getLogger(ErrorHandler.class);
    protected final String message;
    protected String stackTrace = "";
    protected String type;
    protected NanoHTTPD.Response.IStatus status = NanoHTTPD.Response.Status.INTERNAL_ERROR;

    public ErrorHandler(String message) {
        this.message = message;
    }

    public ErrorHandler(NanoHTTPD.Response.IStatus status) {
        this(status.getDescription());
        this.status = status;
    }

    public ErrorHandler(NanoHTTPD.Response.IStatus status, String message) {
        this(status.getRequestStatus() + " " + message);
        this.status = status;
    }

    public ErrorHandler(Exception e) {
        this.message = e.getMessage();
        this.type = e.getClass().getName();
        this.stackTrace = Arrays.toString(e.getStackTrace());
    }

    public String getText() {
        return "<html><body><h3>Error " + this.message + "</h3><p>" + this.stackTrace + "</p></body></html>";
    }

    public String getJson() {
        ObjectMapper mapper = new ObjectMapper();
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("status", this.getStatus());
        map.put("statusCode", this.getStatus().getRequestStatus());
        map.put("message", this.message);
        if (this.stackTrace != null && this.stackTrace.length() > 0) {
            map.put("stackTrace", this.stackTrace);
        }
        if (this.type != null) {
            map.put("type", this.type);
        }
        try {
            return mapper.writeValueAsString(map);
        }
        catch (JsonProcessingException e) {
            log.error(ExceptionUtils.getStackTrace((Throwable)e));
            return this.getText();
        }
    }

    public String getMimeType() {
        return "text/html";
    }

    public NanoHTTPD.Response.IStatus getStatus() {
        return this.status;
    }

    public NanoHTTPD.Response get(RouterNanoHTTPD.UriResource uriResource, Map<String, String> map, NanoHTTPD.IHTTPSession ihttpSession) {
        String accept = (String)ihttpSession.getHeaders().get("accept");
        NanoHTTPD.Response res = "application/json".equals(accept) ? NanoHTTPD.newFixedLengthResponse((NanoHTTPD.Response.IStatus)this.getStatus(), (String)"application/json", (String)this.getJson()) : NanoHTTPD.newFixedLengthResponse((NanoHTTPD.Response.IStatus)this.getStatus(), (String)this.getMimeType(), (String)this.getText());
        CorsHandler.enable(ihttpSession, res);
        return res;
    }

    public NanoHTTPD.Response put(RouterNanoHTTPD.UriResource uriResource, Map<String, String> map, NanoHTTPD.IHTTPSession ihttpSession) {
        return new ErrorHandler((NanoHTTPD.Response.IStatus)NanoHTTPD.Response.Status.METHOD_NOT_ALLOWED).get(uriResource, map, ihttpSession);
    }

    public NanoHTTPD.Response post(RouterNanoHTTPD.UriResource uriResource, Map<String, String> map, NanoHTTPD.IHTTPSession ihttpSession) {
        return new ErrorHandler((NanoHTTPD.Response.IStatus)NanoHTTPD.Response.Status.METHOD_NOT_ALLOWED).get(uriResource, map, ihttpSession);
    }

    public NanoHTTPD.Response delete(RouterNanoHTTPD.UriResource uriResource, Map<String, String> map, NanoHTTPD.IHTTPSession ihttpSession) {
        return new ErrorHandler((NanoHTTPD.Response.IStatus)NanoHTTPD.Response.Status.METHOD_NOT_ALLOWED).get(uriResource, map, ihttpSession);
    }

    public NanoHTTPD.Response other(String s, RouterNanoHTTPD.UriResource uriResource, Map<String, String> map, NanoHTTPD.IHTTPSession ihttpSession) {
        return new ErrorHandler((NanoHTTPD.Response.IStatus)NanoHTTPD.Response.Status.METHOD_NOT_ALLOWED).get(uriResource, map, ihttpSession);
    }
}

